/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DiskNormalizedCostBalancerStrategy
extends CostBalancerStrategy {
    public DiskNormalizedCostBalancerStrategy(ListeningExecutorService exec) {
        super(exec);
    }

    @Override
    protected double computeCost(DataSegment proposalSegment, ServerHolder server, boolean includeCurrentServer) {
        double cost = super.computeCost(proposalSegment, server, includeCurrentServer);
        if (cost == Double.POSITIVE_INFINITY) {
            return cost;
        }
        int nSegments = 1;
        if (server.getServer().getSegments().size() > 0) {
            nSegments = server.getServer().getSegments().size();
        }
        double normalizedCost = cost / (double)nSegments;
        double usageRatio = (double)server.getSizeUsed().longValue() / (double)server.getServer().getMaxSize();
        return normalizedCost * usageRatio;
    }
}

