/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.virtual.BaseSingleValueDimensionSelector;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionObjectSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ExpressionObjectSelector makeObjectColumnSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        return ExpressionObjectSelector.from(columnSelectorFactory, expression);
    }

    public static LongColumnSelector makeLongColumnSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final Long nullValue) {
        final ExpressionObjectSelector baseSelector = ExpressionObjectSelector.from(columnSelectorFactory, expression);
        class ExpressionLongColumnSelector
        implements LongColumnSelector {
            ExpressionLongColumnSelector() {
            }

            @Override
            public long getLong() {
                ExprEval exprEval = baseSelector.get();
                return exprEval.isNull() ? nullValue.longValue() : exprEval.asLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.get().isNull() && nullValue == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        }
        return new ExpressionLongColumnSelector();
    }

    public static FloatColumnSelector makeFloatColumnSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final Float nullValue) {
        final ExpressionObjectSelector baseSelector = ExpressionObjectSelector.from(columnSelectorFactory, expression);
        class ExpressionFloatColumnSelector
        implements FloatColumnSelector {
            ExpressionFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                ExprEval exprEval = baseSelector.get();
                return exprEval.isNull() ? nullValue.floatValue() : (float)exprEval.asDouble();
            }

            @Override
            public boolean isNull() {
                return baseSelector.get().isNull() && nullValue == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        }
        return new ExpressionFloatColumnSelector();
    }

    public static DoubleColumnSelector makeDoubleColumnSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final Double nullValue) {
        final ExpressionObjectSelector baseSelector = ExpressionObjectSelector.from(columnSelectorFactory, expression);
        class ExpressionDoubleColumnSelector
        implements DoubleColumnSelector {
            ExpressionDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                Double number = baseSelector.get().asDouble();
                return number != null ? number.doubleValue() : nullValue.doubleValue();
            }

            @Override
            public boolean isNull() {
                ExprEval exprEval = baseSelector.get();
                return exprEval.isNull() && nullValue == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        }
        return new ExpressionDoubleColumnSelector();
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final ExtractionFn extractionFn) {
        final ExpressionObjectSelector baseSelector = ExpressionObjectSelector.from(columnSelectorFactory, expression);
        if (extractionFn == null) {
            class DefaultExpressionDimensionSelector
            extends BaseSingleValueDimensionSelector {
                final /* synthetic */ ExpressionObjectSelector val$baseSelector;

                DefaultExpressionDimensionSelector(ExpressionObjectSelector expressionObjectSelector) {
                    this.val$baseSelector = expressionObjectSelector;
                }

                @Override
                protected String getValue() {
                    return NullHandlingHelper.defaultToNull(this.val$baseSelector.get().asString());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", this.val$baseSelector);
                }
            }
            return new DefaultExpressionDimensionSelector(baseSelector);
        }
        class ExtractionExpressionDimensionSelector
        extends BaseSingleValueDimensionSelector {
            ExtractionExpressionDimensionSelector() {
            }

            @Override
            protected String getValue() {
                return extractionFn.apply(NullHandlingHelper.defaultToNull(baseSelector.get().asString()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new ExtractionExpressionDimensionSelector();
    }
}

