/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class ExpressionObjectSelector
implements ObjectColumnSelector<ExprEval> {
    private final Expr expression;
    private final Expr.ObjectBinding bindings;

    private ExpressionObjectSelector(Expr.ObjectBinding bindings, Expr expression) {
        this.bindings = Preconditions.checkNotNull(bindings, "bindings");
        this.expression = Preconditions.checkNotNull(expression, "expression");
    }

    static ExpressionObjectSelector from(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        return new ExpressionObjectSelector(ExpressionObjectSelector.createBindings(columnSelectorFactory, expression), expression);
    }

    private static Expr.ObjectBinding createBindings(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        HashMap<String, Supplier<Object>> suppliers = Maps.newHashMap();
        for (String columnName : Parser.findRequiredBindings(expression)) {
            ValueType nativeType;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType valueType = nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            Supplier<Object> supplier = nativeType == ValueType.FLOAT ? columnSelectorFactory.makeFloatColumnSelector(columnName)::getFloat : (nativeType == ValueType.LONG ? columnSelectorFactory.makeLongColumnSelector(columnName)::getLong : (nativeType == ValueType.DOUBLE ? columnSelectorFactory.makeDoubleColumnSelector(columnName)::getDouble : (nativeType == ValueType.STRING ? ExpressionObjectSelector.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName))) : (nativeType == null ? ExpressionObjectSelector.supplierFromObjectSelector(columnSelectorFactory.makeObjectColumnSelector(columnName)) : null))));
            if (supplier == null) continue;
            suppliers.put(columnName, supplier);
        }
        return Parser.withSuppliers(suppliers);
    }

    @Nonnull
    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector) {
        Preconditions.checkNotNull(selector, "selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 0) {
                return NullHandlingHelper.nullToDefault((String)null);
            }
            if (row.size() == 1) {
                return NullHandlingHelper.nullToDefault(selector.lookupName(row.get(0)));
            }
            return NullHandlingHelper.nullToDefault((String)null);
        };
    }

    @Nullable
    @VisibleForTesting
    static Supplier<Object> supplierFromObjectSelector(ObjectColumnSelector selector) {
        Class clazz;
        block6: {
            block5: {
                if (selector == null) {
                    return Suppliers.ofInstance(NullHandlingHelper.nullToDefault((String)null));
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block5;
                if (!String.class.isAssignableFrom(clazz)) break block6;
            }
            return selector::get;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.get();
                if (val instanceof String) {
                    return NullHandlingHelper.nullToDefault((String)val);
                }
                if (val instanceof Number) {
                    return val;
                }
                return NullHandlingHelper.nullToDefault((String)null);
            };
        }
        return null;
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    public ExprEval get() {
        return this.expression.eval(this.bindings);
    }
}

