/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.FloatColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedFloatsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnSupplier;

public class FloatGenericColumnPartSerdeV2
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static FloatGenericColumnPartSerdeV2 createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder, @Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        return new FloatGenericColumnPartSerdeV2(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private FloatGenericColumnPartSerdeV2(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ColumnPartSerde.Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig) -> {
            ImmutableBitmap bitmap;
            int offset = buffer.getInt();
            int initialPos = buffer.position();
            CompressedFloatsIndexedSupplier column = CompressedFloatsIndexedSupplier.fromByteBuffer(buffer, this.byteOrder, builder.getFileMapper());
            buffer.position(initialPos + offset);
            if (buffer.hasRemaining()) {
                bitmap = ByteBufferSerializer.read(buffer, this.bitmapSerdeFactory.getObjectStrategy());
                builder.setNullValueBitmap(Suppliers.ofInstance(bitmap));
            } else {
                bitmap = this.bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap();
            }
            builder.setType(ValueType.FLOAT).setHasMultipleValues(false).setGenericColumn(new FloatGenericColumnSupplier(column, this.byteOrder, bitmap));
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private FloatColumnSerializer delegate = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(FloatColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public FloatGenericColumnPartSerdeV2 build() {
            return new FloatGenericColumnPartSerdeV2(this.byteOrder, this.bitmapSerdeFactory, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel, FileSmoosher fileSmoosher) throws IOException {
                    delegate.writeToChannel(channel, fileSmoosher);
                }
            });
        }
    }
}

