/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.CompressedVSizeIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.CompressedVSizeIndexedV3Supplier;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferSerializer;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIntsWriter;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;
import org.apache.hive.druid.io.druid.segment.data.IndexedRTree;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexed;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;
import org.apache.hive.druid.io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.hive.druid.io.druid.segment.serde.SpatialIndexColumnPartSupplier;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private static final int NO_FLAGS = 0;
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static DictionaryEncodedColumnPartSerde createDeserializer(@Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory, @NotNull @JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DictionaryEncodedColumnPartSerde(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private DictionaryEncodedColumnPartSerde(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ColumnPartSerde.Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                WritableSupplier<IndexedInts> rSingleValuedColumn;
                WritableSupplier<IndexedMultivalue<IndexedInts>> rMultiValuedColumn;
                VERSION rVersion = VERSION.fromByte(buffer.get());
                int rFlags = rVersion.compareTo(VERSION.COMPRESSED) >= 0 ? buffer.getInt() : (rVersion.equals((Object)VERSION.UNCOMPRESSED_MULTI_VALUE) ? Feature.MULTI_VALUE.getMask() : 0);
                boolean hasMultipleValues = Feature.MULTI_VALUE.isSet(rFlags) || Feature.MULTI_VALUE_V3.isSet(rFlags);
                GenericIndexed<String> rDictionary = GenericIndexed.read(buffer, GenericIndexed.STRING_STRATEGY, builder.getFileMapper());
                builder.setType(ValueType.STRING);
                if (hasMultipleValues) {
                    rMultiValuedColumn = this.readMultiValuedColumn(rVersion, buffer, rFlags, builder.getFileMapper());
                    rSingleValuedColumn = null;
                } else {
                    rSingleValuedColumn = this.readSingleValuedColumn(rVersion, buffer, builder.getFileMapper());
                    rMultiValuedColumn = null;
                }
                builder.setHasMultipleValues(hasMultipleValues).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(rDictionary, rSingleValuedColumn, rMultiValuedColumn, columnConfig.columnCacheSizeBytes()));
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(buffer, DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getObjectStrategy(), builder.getFileMapper());
                builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory(), rBitmaps, rDictionary));
                ImmutableRTree rSpatialIndex = null;
                if (buffer.hasRemaining()) {
                    rSpatialIndex = ByteBufferSerializer.read(buffer, new IndexedRTree.ImmutableRTreeObjectStrategy(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory()));
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(rSpatialIndex));
                }
            }

            private WritableSupplier<IndexedInts> readSingleValuedColumn(VERSION version, ByteBuffer buffer, SmooshedFileMapper fileMapper) {
                switch (version) {
                    case UNCOMPRESSED_SINGLE_VALUE: {
                        return VSizeIndexedInts.readFromByteBuffer(buffer).asWritableSupplier();
                    }
                    case COMPRESSED: {
                        return CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder, fileMapper);
                    }
                }
                throw new IAE("Unsupported single-value version[%s]", new Object[]{version});
            }

            private WritableSupplier<IndexedMultivalue<IndexedInts>> readMultiValuedColumn(VERSION version, ByteBuffer buffer, int flags, SmooshedFileMapper fileMapper) {
                switch (version) {
                    case UNCOMPRESSED_MULTI_VALUE: {
                        return VSizeIndexed.readFromByteBuffer(buffer).asWritableSupplier();
                    }
                    case COMPRESSED: {
                        if (Feature.MULTI_VALUE.isSet(flags)) {
                            return CompressedVSizeIndexedSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder, fileMapper);
                        }
                        if (Feature.MULTI_VALUE_V3.isSet(flags)) {
                            return CompressedVSizeIndexedV3Supplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder, fileMapper);
                        }
                        throw new IAE("Unrecognized multi-value flag[%d]", flags);
                    }
                }
                throw new IAE("Unsupported multi-value version[%s]", new Object[]{version});
            }
        };
    }

    public static class SerializerBuilder {
        private VERSION version = null;
        private int flags = 0;
        private GenericIndexedWriter<String> dictionaryWriter = null;
        private IndexedIntsWriter valueWriter = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = null;
        private ByteBufferWriter<ImmutableRTree> spatialIndexWriter = null;
        private ByteOrder byteOrder = null;

        public SerializerBuilder withDictionary(GenericIndexedWriter<String> dictionaryWriter) {
            this.dictionaryWriter = dictionaryWriter;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public SerializerBuilder withBitmapIndex(GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter) {
            this.bitmapIndexWriter = bitmapIndexWriter;
            return this;
        }

        public SerializerBuilder withSpatialIndex(ByteBufferWriter<ImmutableRTree> spatialIndexWriter) {
            this.spatialIndexWriter = spatialIndexWriter;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withValue(IndexedIntsWriter valueWriter, boolean hasMultiValue, boolean compressed) {
            this.valueWriter = valueWriter;
            if (hasMultiValue) {
                if (compressed) {
                    this.version = VERSION.COMPRESSED;
                    this.flags |= Feature.MULTI_VALUE_V3.getMask();
                } else {
                    this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
                    this.flags |= Feature.MULTI_VALUE.getMask();
                }
            } else {
                this.version = compressed ? VERSION.COMPRESSED : VERSION.UNCOMPRESSED_SINGLE_VALUE;
            }
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            return new DictionaryEncodedColumnPartSerde(this.byteOrder, this.bitmapSerdeFactory, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    long size = 1 + (version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0);
                    if (dictionaryWriter != null) {
                        size += dictionaryWriter.getSerializedSize();
                    }
                    if (valueWriter != null) {
                        size += valueWriter.getSerializedSize();
                    }
                    if (bitmapIndexWriter != null) {
                        size += bitmapIndexWriter.getSerializedSize();
                    }
                    if (spatialIndexWriter != null) {
                        size += spatialIndexWriter.getSerializedSize();
                    }
                    return size;
                }

                @Override
                public void write(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    channel.write(ByteBuffer.wrap(new byte[]{version.asByte()}));
                    if (version.compareTo(VERSION.COMPRESSED) >= 0) {
                        channel.write(ByteBuffer.wrap(Ints.toByteArray(flags)));
                    }
                    if (dictionaryWriter != null) {
                        dictionaryWriter.writeToChannel(channel, smoosher);
                    }
                    if (valueWriter != null) {
                        valueWriter.writeToChannel(channel, smoosher);
                    }
                    if (bitmapIndexWriter != null) {
                        bitmapIndexWriter.writeToChannel(channel, smoosher);
                    }
                    if (spatialIndexWriter != null) {
                        spatialIndexWriter.writeToChannel(channel, smoosher);
                    }
                }
            });
        }
    }

    static enum VERSION {
        UNCOMPRESSED_SINGLE_VALUE,
        UNCOMPRESSED_MULTI_VALUE,
        COMPRESSED;


        public static VERSION fromByte(byte b) {
            VERSION[] values = VERSION.values();
            Preconditions.checkArgument(b < values.length, "Unsupported dictionary column version[%s]", b);
            return values[b];
        }

        public byte asByte() {
            return (byte)this.ordinal();
        }
    }

    static enum Feature {
        MULTI_VALUE,
        MULTI_VALUE_V3;


        public boolean isSet(int flags) {
            return (this.getMask() & flags) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

