/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.loading.LoadSpec;
import org.apache.hive.druid.io.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.segment.loading.SegmentizerFactory;
import org.apache.hive.druid.io.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.io.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentLoaderLocalCacheManager
implements SegmentLoader {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoaderLocalCacheManager.class);
    private final IndexIO indexIO;
    private final SegmentLoaderConfig config;
    private final ObjectMapper jsonMapper;
    private final List<StorageLocation> locations;
    private final Object lock = new Object();
    private static final Comparator<StorageLocation> COMPARATOR = new Comparator<StorageLocation>(){

        @Override
        public int compare(StorageLocation left, StorageLocation right) {
            return Longs.compare(right.available(), left.available());
        }
    };

    @Inject
    public SegmentLoaderLocalCacheManager(IndexIO indexIO, SegmentLoaderConfig config, @Json ObjectMapper mapper) {
        this.indexIO = indexIO;
        this.config = config;
        this.jsonMapper = mapper;
        this.locations = Lists.newArrayList();
        for (StorageLocationConfig locationConfig : config.getLocations()) {
            this.locations.add(new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize()));
        }
    }

    public SegmentLoaderLocalCacheManager withConfig(SegmentLoaderConfig config) {
        return new SegmentLoaderLocalCacheManager(this.indexIO, config, this.jsonMapper);
    }

    @Override
    public boolean isSegmentLoaded(DataSegment segment) {
        return this.findStorageLocationIfLoaded(segment) != null;
    }

    public StorageLocation findStorageLocationIfLoaded(DataSegment segment) {
        for (StorageLocation location : this.getSortedList(this.locations)) {
            File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir(segment));
            if (!localStorageDir.exists()) continue;
            return location;
        }
        return null;
    }

    @Override
    public Segment getSegment(DataSegment segment) throws SegmentLoadingException {
        SegmentizerFactory factory;
        File segmentFiles = this.getSegmentFiles(segment);
        File factoryJson = new File(segmentFiles, "factory.json");
        if (factoryJson.exists()) {
            try {
                factory = this.jsonMapper.readValue(factoryJson, SegmentizerFactory.class);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "%s", e.getMessage());
            }
        } else {
            factory = new MMappedQueryableSegmentizerFactory(this.indexIO);
        }
        return factory.factorize(segment, segmentFiles);
    }

    @Override
    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        String storageDir = DataSegmentPusher.getDefaultStorageDir(segment);
        if (loc == null) {
            loc = this.loadSegmentWithRetry(segment, storageDir);
        }
        loc.addSegment(segment);
        return new File(loc.getPath(), storageDir);
    }

    private StorageLocation loadSegmentWithRetry(DataSegment segment, String storageDirStr) throws SegmentLoadingException {
        for (StorageLocation loc : this.getSortedList(this.locations)) {
            if (!loc.canHandle(segment.getSize())) {
                throw new ISE("Segment[%s:%,d] too large for storage[%s:%,d].", segment.getIdentifier(), segment.getSize(), loc.getPath(), loc.available());
            }
            File storageDir = new File(loc.getPath(), storageDirStr);
            try {
                this.loadInLocationWithStartMarker(segment, storageDir);
                return loc;
            }
            catch (SegmentLoadingException e) {
                log.makeAlert(e, "Failed to load segment in current location %s, try next location if any", loc.getPath().getAbsolutePath()).addData("location", loc.getPath().getAbsolutePath()).emit();
                try {
                    this.cleanupCacheFiles(loc.getPath(), storageDir);
                }
                catch (IOException e1) {
                    log.error(e1, "Failed to cleanup location " + storageDir.getAbsolutePath(), new Object[0]);
                }
            }
        }
        throw new SegmentLoadingException("Failed to load segment %s in all locations.", segment.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInLocationWithStartMarker(DataSegment segment, File storageDir) throws SegmentLoadingException {
        File downloadStartMarker = new File(storageDir, "downloadStartMarker");
        Object object = this.lock;
        synchronized (object) {
            if (!storageDir.mkdirs()) {
                log.debug("Unable to make parent file[%s]", storageDir);
            }
            try {
                if (!downloadStartMarker.createNewFile()) {
                    throw new SegmentLoadingException("Was not able to create new download marker for [%s]", storageDir);
                }
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to create marker file for [%s]", storageDir);
            }
        }
        this.loadInLocation(segment, storageDir);
        if (!downloadStartMarker.delete()) {
            throw new SegmentLoadingException("Unable to remove marker file for [%s]", storageDir);
        }
    }

    private void loadInLocation(DataSegment segment, File storageDir) throws SegmentLoadingException {
        LoadSpec loadSpec = this.jsonMapper.convertValue(segment.getLoadSpec(), LoadSpec.class);
        LoadSpec.LoadSpecResult result = loadSpec.loadSegment(storageDir);
        if (result.getSize() != segment.getSize()) {
            log.warn("Segment [%s] is different than expected size. Expected [%d] found [%d]", segment.getIdentifier(), segment.getSize(), result.getSize());
        }
    }

    @Override
    public void cleanup(DataSegment segment) throws SegmentLoadingException {
        if (!this.config.isDeleteOnRemove()) {
            return;
        }
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            log.info("Asked to cleanup something[%s] that didn't exist.  Skipping.", segment);
            return;
        }
        try {
            for (StorageLocation location : this.getSortedList(this.locations)) {
                File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir(segment));
                if (!localStorageDir.exists()) continue;
                File cacheFile = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir(segment));
                this.cleanupCacheFiles(location.getPath(), cacheFile);
                location.removeSegment(segment);
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCacheFiles(File baseFile, File cacheFile) throws IOException {
        File[] children;
        if (cacheFile.equals(baseFile)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            log.info("Deleting directory[%s]", cacheFile);
            try {
                FileUtils.deleteDirectory((File)cacheFile);
            }
            catch (Exception e) {
                log.error("Unable to remove file[%s]", cacheFile);
            }
        }
        File parent = cacheFile.getParentFile();
        if (parent != null && ((children = parent.listFiles()) == null || children.length == 0)) {
            this.cleanupCacheFiles(baseFile, parent);
        }
    }

    public List<StorageLocation> getSortedList(List<StorageLocation> locs) {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(locs);
        Collections.sort(locations, COMPARATOR);
        return locations;
    }
}

