/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.indexing;

import java.io.File;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.indexing.TuningConfig;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Period;

public class RealtimeTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int defaultMaxRowsInMemory = 75000;
    private static final Period defaultIntermediatePersistPeriod = new Period((Object)"PT10M");
    private static final Period defaultWindowPeriod = new Period((Object)"PT10M");
    private static final VersioningPolicy defaultVersioningPolicy = new IntervalStartVersioningPolicy();
    private static final RejectionPolicyFactory defaultRejectionPolicyFactory = new ServerTimeRejectionPolicyFactory();
    private static final int defaultMaxPendingPersists = 0;
    private static final ShardSpec defaultShardSpec = NoneShardSpec.instance();
    private static final IndexSpec defaultIndexSpec = new IndexSpec();
    private static final Boolean defaultReportParseExceptions = Boolean.FALSE;
    private static final long defaultHandoffConditionTimeout = 0L;
    private static final long defaultAlertTimeout = 0L;
    private final int maxRowsInMemory;
    private final Period intermediatePersistPeriod;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final VersioningPolicy versioningPolicy;
    private final RejectionPolicyFactory rejectionPolicyFactory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;
    private final IndexSpec indexSpec;
    private final int persistThreadPriority;
    private final int mergeThreadPriority;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final long alertTimeout;

    private static File createNewBasePersistDirectory() {
        return Files.createTempDir();
    }

    public static RealtimeTuningConfig makeDefaultTuningConfig(File basePersistDirectory) {
        return new RealtimeTuningConfig(75000, defaultIntermediatePersistPeriod, defaultWindowPeriod, basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory, defaultVersioningPolicy, defaultRejectionPolicyFactory, 0, defaultShardSpec, defaultIndexSpec, true, 0, 0, defaultReportParseExceptions, 0L, 0L);
    }

    @JsonCreator
    public RealtimeTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="persistThreadPriority") int persistThreadPriority, @JsonProperty(value="mergeThreadPriority") int mergeThreadPriority, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="alertTimeout") Long alertTimeout) {
        this.maxRowsInMemory = maxRowsInMemory == null ? 75000 : maxRowsInMemory;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaultIntermediatePersistPeriod : intermediatePersistPeriod;
        this.windowPeriod = windowPeriod == null ? defaultWindowPeriod : windowPeriod;
        this.basePersistDirectory = basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory;
        this.versioningPolicy = versioningPolicy == null ? defaultVersioningPolicy : versioningPolicy;
        this.rejectionPolicyFactory = rejectionPolicyFactory == null ? defaultRejectionPolicyFactory : rejectionPolicyFactory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? defaultShardSpec : shardSpec;
        this.indexSpec = indexSpec == null ? defaultIndexSpec : indexSpec;
        this.mergeThreadPriority = mergeThreadPriority;
        this.persistThreadPriority = persistThreadPriority;
        this.reportParseExceptions = reportParseExceptions == null ? defaultReportParseExceptions : reportParseExceptions;
        this.handoffConditionTimeout = handoffConditionTimeout == null ? 0L : handoffConditionTimeout;
        Preconditions.checkArgument(this.handoffConditionTimeout >= 0L, "handoffConditionTimeout must be >= 0");
        this.alertTimeout = alertTimeout == null ? 0L : alertTimeout;
        Preconditions.checkArgument(this.alertTimeout >= 0L, "alertTimeout must be >= 0");
    }

    @Override
    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @Override
    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @Override
    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    @JsonProperty(value="rejectionPolicy")
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    @Override
    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Deprecated
    @JsonProperty
    public Boolean getBuildV9Directly() {
        return true;
    }

    @JsonProperty
    public int getPersistThreadPriority() {
        return this.persistThreadPriority;
    }

    @JsonProperty
    public int getMergeThreadPriority() {
        return this.mergeThreadPriority;
    }

    @Override
    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public long getAlertTimeout() {
        return this.alertTimeout;
    }

    public RealtimeTuningConfig withVersioningPolicy(VersioningPolicy policy) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.intermediatePersistPeriod, this.windowPeriod, this.basePersistDirectory, policy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout);
    }

    public RealtimeTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.intermediatePersistPeriod, this.windowPeriod, dir, this.versioningPolicy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout);
    }
}

