/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.incremental.OnheapIncrementalIndex;

public class OffheapIncrementalIndex
extends IncrementalIndex<BufferAggregator> {
    private static final Logger log = new Logger(OffheapIncrementalIndex.class);
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final List<ResourceHolder<ByteBuffer>> aggBuffers = new ArrayList<ResourceHolder<ByteBuffer>>();
    private final List<int[]> indexAndOffsets = new ArrayList<int[]>();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private volatile int[] aggOffsetInBuffer;
    private volatile int aggsTotalSize;
    private String outOfRowsReason = null;

    OffheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean concurrentEventAdd, boolean sortFacts, int maxRowCount, NonBlockingPool<ByteBuffer> bufferPool) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions, concurrentEventAdd);
        this.maxRowCount = maxRowCount;
        this.bufferPool = bufferPool;
        this.facts = incrementalIndexSchema.isRollup() ? new IncrementalIndex.RollupFactsHolder(sortFacts, this.dimsComparator(), this.getDimensions()) : new IncrementalIndex.PlainFactsHolder(sortFacts);
        ResourceHolder<ByteBuffer> bb = bufferPool.take();
        if (bb.get().capacity() < this.aggsTotalSize) {
            bb.close();
            throw new IAE("bufferPool buffers capacity must be >= [%s]", this.aggsTotalSize);
        }
        this.aggBuffers.add(bb);
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    protected BufferAggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics, boolean concurrentEventAdd) {
        this.selectors = Maps.newHashMap();
        this.aggOffsetInBuffer = new int[metrics.length];
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            ColumnSelectorFactory columnSelectorFactory = this.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics);
            this.selectors.put(agg.getName(), new OnheapIncrementalIndex.ObjectCachingColumnSelectorFactory(columnSelectorFactory, concurrentEventAdd));
            this.aggOffsetInBuffer[i] = i == 0 ? 0 : this.aggOffsetInBuffer[i - 1] + metrics[i - 1].getMaxIntermediateSize();
        }
        this.aggsTotalSize = this.aggOffsetInBuffer[metrics.length - 1] + metrics[metrics.length - 1].getMaxIntermediateSize();
        return new BufferAggregator[metrics.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
        ByteBuffer aggBuffer;
        int bufferOffset;
        OffheapIncrementalIndex offheapIncrementalIndex = this;
        synchronized (offheapIncrementalIndex) {
            int bufferIndex;
            int priorIndex = this.facts.getPriorIndex(key);
            if (-1 != priorIndex) {
                int[] indexAndOffset = this.indexAndOffsets.get(priorIndex);
                bufferIndex = indexAndOffset[0];
                bufferOffset = indexAndOffset[1];
                aggBuffer = this.aggBuffers.get(bufferIndex).get();
            } else {
                int[] lastAggregatorsIndexAndOffset;
                if (metrics.length > 0 && ((BufferAggregator[])this.getAggs())[0] == null) {
                    rowContainer.set(row);
                    for (int i = 0; i < metrics.length; ++i) {
                        AggregatorFactory agg = metrics[i];
                        ((BufferAggregator[])this.getAggs())[i] = agg.factorizeBuffered(this.selectors.get(agg.getName()));
                    }
                    rowContainer.set(null);
                }
                bufferIndex = this.aggBuffers.size() - 1;
                ByteBuffer lastBuffer = this.aggBuffers.isEmpty() ? null : this.aggBuffers.get(this.aggBuffers.size() - 1).get();
                int[] nArray = lastAggregatorsIndexAndOffset = this.indexAndOffsets.isEmpty() ? null : this.indexAndOffsets.get(this.indexAndOffsets.size() - 1);
                if (lastAggregatorsIndexAndOffset != null && lastAggregatorsIndexAndOffset[0] != bufferIndex) {
                    throw new ISE("last row's aggregate's buffer and last buffer index must be same", new Object[0]);
                }
                bufferOffset = this.aggsTotalSize + (lastAggregatorsIndexAndOffset != null ? lastAggregatorsIndexAndOffset[1] : 0);
                if (lastBuffer != null && lastBuffer.capacity() - bufferOffset >= this.aggsTotalSize) {
                    aggBuffer = lastBuffer;
                } else {
                    ResourceHolder<ByteBuffer> bb = this.bufferPool.take();
                    this.aggBuffers.add(bb);
                    bufferIndex = this.aggBuffers.size() - 1;
                    bufferOffset = 0;
                    aggBuffer = bb.get();
                }
                for (int i = 0; i < metrics.length; ++i) {
                    ((BufferAggregator[])this.getAggs())[i].init(aggBuffer, bufferOffset + this.aggOffsetInBuffer[i]);
                }
                if (numEntries.get() >= this.maxRowCount && this.facts.getPriorIndex(key) == -1) {
                    throw new IndexSizeExceededException("Maximum number of rows [%d] reached", this.maxRowCount);
                }
                Integer rowIndex = this.indexIncrement.getAndIncrement();
                this.indexAndOffsets.add(new int[]{bufferIndex, bufferOffset});
                int prev = this.facts.putIfAbsent(key, rowIndex);
                if (-1 == prev) {
                    numEntries.incrementAndGet();
                } else {
                    throw new ISE("WTF! we are in sychronized block.", new Object[0]);
                }
            }
        }
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            BufferAggregator agg;
            BufferAggregator bufferAggregator = agg = ((BufferAggregator[])this.getAggs())[i];
            synchronized (bufferAggregator) {
                try {
                    agg.aggregate(aggBuffer, bufferOffset + this.aggOffsetInBuffer[i]);
                }
                catch (ParseException e) {
                    if (reportParseExceptions) {
                        throw new ParseException(e, "Encountered parse error for aggregator[%s]", this.getMetricAggs()[i].getName());
                    }
                    log.debug(e, "Encountered parse error, skipping aggregator[%s].", this.getMetricAggs()[i].getName());
                }
                continue;
            }
        }
        rowContainer.set(null);
        return numEntries.get();
    }

    @Override
    public int getLastRowIndex() {
        return this.indexIncrement.get() - 1;
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected BufferAggregator[] getAggsForRow(int rowOffset) {
        return (BufferAggregator[])this.getAggs();
    }

    @Override
    protected Object getAggVal(BufferAggregator agg, int rowOffset, int aggPosition) {
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.get(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggPosition]);
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.getFloat(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.getLong(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.get(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public double getMetricDoubleValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.getDouble(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.isNull(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public void close() {
        super.close();
        this.facts.clear();
        this.indexAndOffsets.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
        Object ex = null;
        for (ResourceHolder<ByteBuffer> buffHolder : this.aggBuffers) {
            buffHolder.close();
        }
        this.aggBuffers.clear();
    }
}

