/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.io.Closeable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Enums;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.incremental.OffheapIncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.SpatialDimensionRowTransformer;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricExtractor;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IncrementalIndex<AggregatorType>
implements Iterable<Row>,
Closeable {
    private volatile DateTime maxIngestedEventTime;
    private static final Map<Object, ValueType> TYPE_MAP = ImmutableMap.builder().put(Long.class, ValueType.LONG).put(Double.class, ValueType.DOUBLE).put(Float.class, ValueType.FLOAT).put(String.class, ValueType.STRING).put((Class<String>)((Object)DimensionSchema.ValueType.LONG), ValueType.LONG).put((Class<String>)((Object)DimensionSchema.ValueType.FLOAT), ValueType.FLOAT).put((Class<String>)((Object)DimensionSchema.ValueType.STRING), ValueType.STRING).put((Class<String>)((Object)DimensionSchema.ValueType.DOUBLE), ValueType.DOUBLE).build();
    private final long minTimestamp;
    private final Granularity gran;
    private final boolean rollup;
    private final List<Function<InputRow, InputRow>> rowTransformers;
    private final VirtualColumns virtualColumns;
    private final AggregatorFactory[] metrics;
    private final AggregatorType[] aggs;
    private final boolean deserializeComplexMetrics;
    private final boolean reportParseExceptions;
    private final Metadata metadata;
    private final Map<String, MetricDesc> metricDescs;
    private final Map<String, DimensionDesc> dimensionDescs;
    private final List<DimensionDesc> dimensionDescsList;
    private final Map<String, ColumnCapabilitiesImpl> columnCapabilities;
    private final AtomicInteger numEntries = new AtomicInteger();
    private final ThreadLocal<InputRow> in = new ThreadLocal();
    private final Supplier<InputRow> rowSupplier = this.in::get;

    public static ColumnSelectorFactory makeColumnSelectorFactory(VirtualColumns virtualColumns, final AggregatorFactory agg, final Supplier<InputRow> in, final boolean deserializeComplexMetrics) {
        final RowBasedColumnSelectorFactory baseSelectorFactory = RowBasedColumnSelectorFactory.create(in, null);
        class IncrementalIndexInputRowColumnSelectorFactory
        implements ColumnSelectorFactory {
            IncrementalIndexInputRowColumnSelectorFactory() {
            }

            @Override
            public LongColumnSelector makeLongColumnSelector(String columnName) {
                return baseSelectorFactory.makeLongColumnSelector(columnName);
            }

            @Override
            public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                return baseSelectorFactory.makeFloatColumnSelector(columnName);
            }

            @Override
            public ObjectColumnSelector makeObjectColumnSelector(final String column) {
                String typeName = agg.getTypeName();
                ObjectColumnSelector rawColumnSelector = baseSelectorFactory.makeObjectColumnSelector(column);
                if (Enums.getIfPresent(ValueType.class, StringUtils.toUpperCase(typeName)).isPresent() && !typeName.equalsIgnoreCase(ValueType.COMPLEX.name()) || !deserializeComplexMetrics) {
                    return rawColumnSelector;
                }
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    throw new ISE("Don't know how to handle type[%s]", typeName);
                }
                final ComplexMetricExtractor extractor = serde.getExtractor();
                return new ObjectColumnSelector(){

                    public Class classOfObject() {
                        return extractor.extractedClass();
                    }

                    public Object get() {
                        return extractor.extractValue((InputRow)in.get(), column);
                    }
                };
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return baseSelectorFactory.makeDimensionSelector(dimensionSpec);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String columnName) {
                return baseSelectorFactory.getColumnCapabilities(columnName);
            }

            @Override
            public DoubleColumnSelector makeDoubleColumnSelector(String columnName) {
                return baseSelectorFactory.makeDoubleColumnSelector(columnName);
            }
        }
        return virtualColumns.wrap(new IncrementalIndexInputRowColumnSelectorFactory());
    }

    protected IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean concurrentEventAdd) {
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.gran = incrementalIndexSchema.getGran();
        this.rollup = incrementalIndexSchema.isRollup();
        this.virtualColumns = incrementalIndexSchema.getVirtualColumns();
        this.metrics = incrementalIndexSchema.getMetrics();
        this.rowTransformers = new CopyOnWriteArrayList<Function<InputRow, InputRow>>();
        this.deserializeComplexMetrics = deserializeComplexMetrics;
        this.reportParseExceptions = reportParseExceptions;
        this.columnCapabilities = Maps.newHashMap();
        this.metadata = new Metadata().setAggregators(IncrementalIndex.getCombiningAggregators(this.metrics)).setTimestampSpec(incrementalIndexSchema.getTimestampSpec()).setQueryGranularity(this.gran).setRollup(this.rollup);
        this.aggs = this.initAggs(this.metrics, this.rowSupplier, deserializeComplexMetrics, concurrentEventAdd);
        this.metricDescs = Maps.newLinkedHashMap();
        for (AggregatorFactory metric : this.metrics) {
            MetricDesc metricDesc = new MetricDesc(this.metricDescs.size(), metric);
            this.metricDescs.put(metricDesc.getName(), metricDesc);
            this.columnCapabilities.put(metricDesc.getName(), metricDesc.getCapabilities());
        }
        DimensionsSpec dimensionsSpec = incrementalIndexSchema.getDimensionsSpec();
        this.dimensionDescs = Maps.newLinkedHashMap();
        this.dimensionDescsList = new ArrayList<DimensionDesc>();
        for (DimensionSchema dimSchema : dimensionsSpec.getDimensions()) {
            ValueType type = TYPE_MAP.get((Object)dimSchema.getValueType());
            String dimName = dimSchema.getName();
            ColumnCapabilitiesImpl capabilities = this.makeCapabilitesFromValueType(type);
            if (dimSchema.getTypeName().equals("spatial")) {
                capabilities.setHasSpatialIndexes(true);
            } else {
                DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dimName, capabilities, dimSchema.getMultiValueHandling());
                this.addNewDimension(dimName, capabilities, handler);
            }
            this.columnCapabilities.put(dimName, capabilities);
        }
        ColumnCapabilitiesImpl timeCapabilities = new ColumnCapabilitiesImpl();
        timeCapabilities.setType(ValueType.LONG);
        this.columnCapabilities.put("__time", timeCapabilities);
        List<SpatialDimensionSchema> spatialDimensions = dimensionsSpec.getSpatialDimensions();
        if (!spatialDimensions.isEmpty()) {
            this.rowTransformers.add(new SpatialDimensionRowTransformer(spatialDimensions));
        }
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public abstract FactsHolder getFacts();

    public abstract boolean canAppendRow();

    public abstract String getOutOfRowsReason();

    protected abstract AggregatorType[] initAggs(AggregatorFactory[] var1, Supplier<InputRow> var2, boolean var3, boolean var4);

    protected abstract Integer addToFacts(AggregatorFactory[] var1, boolean var2, boolean var3, InputRow var4, AtomicInteger var5, TimeAndDims var6, ThreadLocal<InputRow> var7, Supplier<InputRow> var8) throws IndexSizeExceededException;

    public abstract int getLastRowIndex();

    protected abstract AggregatorType[] getAggsForRow(int var1);

    protected abstract Object getAggVal(AggregatorType var1, int var2, int var3);

    protected abstract float getMetricFloatValue(int var1, int var2);

    protected abstract long getMetricLongValue(int var1, int var2);

    protected abstract Object getMetricObjectValue(int var1, int var2);

    protected abstract double getMetricDoubleValue(int var1, int var2);

    protected abstract boolean isNull(int var1, int var2);

    @Override
    public void close() {
    }

    public InputRow formatRow(InputRow row) {
        for (Function<InputRow, InputRow> rowTransformer : this.rowTransformers) {
            row = rowTransformer.apply(row);
        }
        if (row == null) {
            throw new IAE("Row is null? How can this be?!", new Object[0]);
        }
        return row;
    }

    private ValueType getTypeFromDimVal(Object dimVal) {
        List dimValList;
        Object singleVal = dimVal instanceof List ? ((dimValList = (List)dimVal).size() == 0 ? null : dimValList.get(0)) : dimVal;
        if (singleVal == null) {
            return null;
        }
        return TYPE_MAP.get(singleVal.getClass());
    }

    public Map<String, ColumnCapabilitiesImpl> getColumnCapabilities() {
        return this.columnCapabilities;
    }

    public int add(InputRow row) throws IndexSizeExceededException {
        TimeAndDims key = this.toTimeAndDims(row);
        int rv = this.addToFacts(this.metrics, this.deserializeComplexMetrics, this.reportParseExceptions, row, this.numEntries, key, this.in, this.rowSupplier);
        this.updateMaxIngestedTime(row.getTimestamp());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    TimeAndDims toTimeAndDims(InputRow row) throws IndexSizeExceededException {
        Object[] dims;
        if ((row = this.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw new IAE("Cannot add row[%s] because it is below the minTimestamp[%s]", row, new DateTime(this.minTimestamp));
        }
        List<String> rowDimensions = row.getDimensions();
        ArrayList overflow = null;
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            dims = new Object[this.dimensionDescs.size()];
            for (String dimension : rowDimensions) {
                ColumnCapabilitiesImpl capabilities;
                boolean wasNewDim = false;
                DimensionDesc desc = this.dimensionDescs.get(dimension);
                if (desc != null) {
                    capabilities = desc.getCapabilities();
                } else {
                    wasNewDim = true;
                    capabilities = this.columnCapabilities.get(dimension);
                    if (capabilities == null) {
                        capabilities = new ColumnCapabilitiesImpl();
                        capabilities.setType(ValueType.STRING);
                        capabilities.setDictionaryEncoded(true);
                        capabilities.setHasBitmapIndexes(true);
                        this.columnCapabilities.put(dimension, capabilities);
                    }
                    DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dimension, capabilities, null);
                    desc = this.addNewDimension(dimension, capabilities, handler);
                }
                Object raw = row.getRaw(dimension);
                DimensionHandler handler = desc.getHandler();
                DimensionIndexer indexer = desc.getIndexer();
                Object dimsKey = indexer.processRowValsToUnsortedEncodedKeyComponent(raw);
                if (!capabilities.hasMultipleValues() && dimsKey != null && handler.getLengthOfEncodedKeyComponent(dimsKey) > 1) {
                    capabilities.setHasMultipleValues(true);
                }
                if (wasNewDim) {
                    if (overflow == null) {
                        overflow = Lists.newArrayList();
                    }
                    overflow.add(dimsKey);
                    continue;
                }
                if (desc.getIndex() > dims.length || dims[desc.getIndex()] != null) {
                    throw new ISE("Dimension[%s] occurred more than once in InputRow", dimension);
                }
                dims[desc.getIndex()] = dimsKey;
            }
        }
        if (overflow != null) {
            Object[] newDims = new Object[dims.length + overflow.size()];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = overflow.get(i);
            }
            dims = newDims;
        }
        long truncated = 0L;
        if (row.getTimestamp() != null) {
            truncated = this.gran.bucketStart(row.getTimestamp()).getMillis();
        }
        return new TimeAndDims(Math.max(truncated, this.minTimestamp), dims, this.dimensionDescsList);
    }

    private synchronized void updateMaxIngestedTime(DateTime eventTime) {
        if (this.maxIngestedEventTime == null || this.maxIngestedEventTime.isBefore((ReadableInstant)eventTime)) {
            this.maxIngestedEventTime = eventTime;
        }
    }

    public boolean isEmpty() {
        return this.numEntries.get() == 0;
    }

    public int size() {
        return this.numEntries.get();
    }

    private long getMinTimeMillis() {
        return this.getFacts().getMinTimeMillis();
    }

    private long getMaxTimeMillis() {
        return this.getFacts().getMaxTimeMillis();
    }

    public AggregatorType[] getAggs() {
        return this.aggs;
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionNames() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionDesc> getDimensions() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimensionDesc getDimension(String dimension) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return this.dimensionDescs.get(dimension);
        }
    }

    public String getMetricType(String metric) {
        MetricDesc metricDesc = this.metricDescs.get(metric);
        return metricDesc != null ? metricDesc.getType() : null;
    }

    public Class getMetricClass(String metric) {
        MetricDesc metricDesc = this.metricDescs.get(metric);
        switch (metricDesc.getCapabilities().getType()) {
            case COMPLEX: {
                return ComplexMetrics.getSerdeForType(metricDesc.getType()).getObjectStrategy().getClazz();
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
        }
        return null;
    }

    public Interval getInterval() {
        return new Interval(this.minTimestamp, this.isEmpty() ? this.minTimestamp : this.gran.increment(new DateTime(this.getMaxTimeMillis())).getMillis());
    }

    public DateTime getMinTime() {
        return this.isEmpty() ? null : new DateTime(this.getMinTimeMillis());
    }

    public DateTime getMaxTime() {
        return this.isEmpty() ? null : new DateTime(this.getMaxTimeMillis());
    }

    public Integer getDimensionIndex(String dimension) {
        DimensionDesc dimSpec = this.getDimension(dimension);
        return dimSpec == null ? null : Integer.valueOf(dimSpec.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionOrder() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    private ColumnCapabilitiesImpl makeCapabilitesFromValueType(ValueType type) {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl();
        capabilities.setDictionaryEncoded(type == ValueType.STRING);
        capabilities.setHasBitmapIndexes(type == ValueType.STRING);
        capabilities.setType(type);
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDimensionIterable(Iterable<String> oldDimensionOrder, Map<String, ColumnCapabilitiesImpl> oldColumnCapabilities) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (!this.dimensionDescs.isEmpty()) {
                throw new ISE("Cannot load dimension order when existing order[%s] is not empty.", this.dimensionDescs.keySet());
            }
            for (String dim : oldDimensionOrder) {
                if (this.dimensionDescs.get(dim) != null) continue;
                ColumnCapabilitiesImpl capabilities = oldColumnCapabilities.get(dim);
                this.columnCapabilities.put(dim, capabilities);
                DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
                this.addNewDimension(dim, capabilities, handler);
            }
        }
    }

    @GuardedBy(value="dimensionDescs")
    private DimensionDesc addNewDimension(String dim, ColumnCapabilitiesImpl capabilities, DimensionHandler handler) {
        DimensionDesc desc = new DimensionDesc(this.dimensionDescs.size(), dim, capabilities, handler);
        this.dimensionDescs.put(dim, desc);
        this.dimensionDescsList.add(desc);
        return desc;
    }

    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.metricDescs.keySet());
    }

    public List<MetricDesc> getMetrics() {
        return ImmutableList.copyOf(this.metricDescs.values());
    }

    public Integer getMetricIndex(String metricName) {
        MetricDesc metSpec = this.metricDescs.get(metricName);
        return metSpec == null ? null : Integer.valueOf(metSpec.getIndex());
    }

    public ColumnCapabilities getCapabilities(String column) {
        return this.columnCapabilities.get(column);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private static AggregatorFactory[] getCombiningAggregators(AggregatorFactory[] aggregators) {
        AggregatorFactory[] combiningAggregators = new AggregatorFactory[aggregators.length];
        for (int i = 0; i < aggregators.length; ++i) {
            combiningAggregators[i] = aggregators[i].getCombiningFactory();
        }
        return combiningAggregators;
    }

    public Map<String, DimensionHandler> getDimensionHandlers() {
        LinkedHashMap<String, DimensionHandler> handlers = Maps.newLinkedHashMap();
        for (DimensionDesc desc : this.dimensionDescsList) {
            handlers.put(desc.getName(), desc.getHandler());
        }
        return handlers;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null, false).iterator();
    }

    public Iterable<Row> iterableWithPostAggregations(final List<PostAggregator> postAggs, final boolean descending) {
        return new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                List<DimensionDesc> dimensions = IncrementalIndex.this.getDimensions();
                return Iterators.transform(IncrementalIndex.this.getFacts().iterator(descending), timeAndDims -> {
                    int rowOffset = timeAndDims.getRowIndex();
                    Object[] theDims = timeAndDims.getDims();
                    LinkedHashMap<String, Object> theVals = Maps.newLinkedHashMap();
                    for (int i = 0; i < theDims.length; ++i) {
                        Object dim = theDims[i];
                        DimensionDesc dimensionDesc = (DimensionDesc)dimensions.get(i);
                        if (dimensionDesc == null) continue;
                        String dimensionName = dimensionDesc.getName();
                        DimensionHandler handler = dimensionDesc.getHandler();
                        if (dim == null || handler.getLengthOfEncodedKeyComponent(dim) == 0) {
                            theVals.put(dimensionName, null);
                            continue;
                        }
                        DimensionIndexer indexer = dimensionDesc.getIndexer();
                        Object rowVals = indexer.convertUnsortedEncodedKeyComponentToActualArrayOrList(dim, true);
                        theVals.put(dimensionName, rowVals);
                    }
                    AggregatorType[] aggs = IncrementalIndex.this.getAggsForRow(rowOffset);
                    for (int i = 0; i < aggs.length; ++i) {
                        theVals.put(IncrementalIndex.this.metrics[i].getName(), IncrementalIndex.this.getAggVal(aggs[i], rowOffset, i));
                    }
                    if (postAggs != null) {
                        for (PostAggregator postAgg : postAggs) {
                            theVals.put(postAgg.getName(), postAgg.compute(theVals));
                        }
                    }
                    return new MapBasedRow(timeAndDims.getTimestamp(), theVals);
                });
            }
        };
    }

    public DateTime getMaxIngestedEventTime() {
        return this.maxIngestedEventTime;
    }

    protected ColumnSelectorFactory makeColumnSelectorFactory(AggregatorFactory agg, Supplier<InputRow> in, boolean deserializeComplexMetrics) {
        return IncrementalIndex.makeColumnSelectorFactory(this.virtualColumns, agg, in, deserializeComplexMetrics);
    }

    protected final Comparator<TimeAndDims> dimsComparator() {
        return new TimeAndDimsComp(this.dimensionDescsList);
    }

    private static boolean allNull(Object[] dims, int startPosition) {
        for (int i = startPosition; i < dims.length; ++i) {
            if (dims[i] == null) continue;
            return false;
        }
        return true;
    }

    static class PlainFactsHolder
    implements FactsHolder {
        private final boolean sortFacts;
        private final ConcurrentMap<Long, Deque<TimeAndDims>> facts;

        public PlainFactsHolder(boolean sortFacts) {
            this.sortFacts = sortFacts;
            this.facts = sortFacts ? new ConcurrentSkipListMap<Long, Deque<TimeAndDims>>() : new ConcurrentHashMap<Long, Deque<TimeAndDims>>();
        }

        @Override
        public int getPriorIndex(TimeAndDims key) {
            return -1;
        }

        @Override
        public long getMinTimeMillis() {
            if (this.sortFacts) {
                return (Long)((ConcurrentNavigableMap)this.facts).firstKey();
            }
            throw new UnsupportedOperationException("can't get minTime from unsorted facts data.");
        }

        @Override
        public long getMaxTimeMillis() {
            if (this.sortFacts) {
                return (Long)((ConcurrentNavigableMap)this.facts).lastKey();
            }
            throw new UnsupportedOperationException("can't get maxTime from unsorted facts data.");
        }

        @Override
        public Iterator<TimeAndDims> iterator(boolean descending) {
            if (descending && this.sortFacts) {
                return this.concat(((ConcurrentNavigableMap)this.facts).descendingMap().values(), true).iterator();
            }
            return this.concat(this.facts.values(), false).iterator();
        }

        @Override
        public Iterable<TimeAndDims> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            SortedMap subMap = ((ConcurrentNavigableMap)this.facts).subMap((Object)timeStart, (Object)timeEnd);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return this.concat(rangeMap.values(), descending);
        }

        private Iterable<TimeAndDims> concat(Iterable<Deque<TimeAndDims>> iterable, boolean descending) {
            return () -> Iterators.concat(Iterators.transform(iterable.iterator(), input -> descending ? input.descendingIterator() : input.iterator()));
        }

        @Override
        public Iterable<TimeAndDims> keySet() {
            return this.concat(this.facts.values(), false);
        }

        @Override
        public int putIfAbsent(TimeAndDims key, int rowIndex) {
            Long time = key.getTimestamp();
            Deque rows = (Deque)this.facts.get(time);
            if (rows == null) {
                this.facts.putIfAbsent(time, new ConcurrentLinkedDeque());
                rows = (Deque)this.facts.get(time);
            }
            key.setRowIndex(rowIndex);
            rows.add(key);
            return -1;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static class RollupFactsHolder
    implements FactsHolder {
        private final boolean sortFacts;
        private final ConcurrentMap<TimeAndDims, TimeAndDims> facts;
        private final List<DimensionDesc> dimensionDescsList;

        public RollupFactsHolder(boolean sortFacts, Comparator<TimeAndDims> timeAndDimsComparator, List<DimensionDesc> dimensionDescsList) {
            this.sortFacts = sortFacts;
            this.facts = sortFacts ? new ConcurrentSkipListMap<TimeAndDims, TimeAndDims>(timeAndDimsComparator) : new ConcurrentHashMap<TimeAndDims, TimeAndDims>();
            this.dimensionDescsList = dimensionDescsList;
        }

        @Override
        public int getPriorIndex(TimeAndDims key) {
            TimeAndDims timeAndDims = (TimeAndDims)this.facts.get(key);
            return timeAndDims == null ? -1 : timeAndDims.rowIndex;
        }

        @Override
        public long getMinTimeMillis() {
            if (this.sortFacts) {
                return ((TimeAndDims)((ConcurrentNavigableMap)this.facts).firstKey()).getTimestamp();
            }
            throw new UnsupportedOperationException("can't get minTime from unsorted facts data.");
        }

        @Override
        public long getMaxTimeMillis() {
            if (this.sortFacts) {
                return ((TimeAndDims)((ConcurrentNavigableMap)this.facts).lastKey()).getTimestamp();
            }
            throw new UnsupportedOperationException("can't get maxTime from unsorted facts data.");
        }

        @Override
        public Iterator<TimeAndDims> iterator(boolean descending) {
            if (descending && this.sortFacts) {
                return ((ConcurrentNavigableMap)this.facts).descendingMap().keySet().iterator();
            }
            return this.keySet().iterator();
        }

        @Override
        public Iterable<TimeAndDims> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            if (!this.sortFacts) {
                throw new UnsupportedOperationException("can't get timeRange from unsorted facts data.");
            }
            TimeAndDims start = new TimeAndDims(timeStart, new Object[0], this.dimensionDescsList);
            TimeAndDims end = new TimeAndDims(timeEnd, new Object[0], this.dimensionDescsList);
            SortedMap subMap = ((ConcurrentNavigableMap)this.facts).subMap(start, end);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return rangeMap.keySet();
        }

        @Override
        public Iterable<TimeAndDims> keySet() {
            return this.facts.keySet();
        }

        @Override
        public int putIfAbsent(TimeAndDims key, int rowIndex) {
            key.setRowIndex(rowIndex);
            TimeAndDims prev = this.facts.putIfAbsent(key, key);
            return prev == null ? -1 : prev.rowIndex;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static interface FactsHolder {
        public int getPriorIndex(TimeAndDims var1);

        public long getMinTimeMillis();

        public long getMaxTimeMillis();

        public Iterator<TimeAndDims> iterator(boolean var1);

        public Iterable<TimeAndDims> timeRangeIterable(boolean var1, long var2, long var4);

        public Iterable<TimeAndDims> keySet();

        public int putIfAbsent(TimeAndDims var1, int var2);

        public void clear();
    }

    @VisibleForTesting
    static final class TimeAndDimsComp
    implements Comparator<TimeAndDims> {
        private List<DimensionDesc> dimensionDescs;

        public TimeAndDimsComp(List<DimensionDesc> dimDescs) {
            this.dimensionDescs = dimDescs;
        }

        @Override
        public int compare(TimeAndDims lhs, TimeAndDims rhs) {
            int retVal = Longs.compare(lhs.timestamp, rhs.timestamp);
            int numComparisons = Math.min(lhs.dims.length, rhs.dims.length);
            int index = 0;
            while (retVal == 0 && index < numComparisons) {
                Object lhsIdxs = lhs.dims[index];
                Object rhsIdxs = rhs.dims[index];
                if (lhsIdxs == null) {
                    if (rhsIdxs == null) {
                        ++index;
                        continue;
                    }
                    return -1;
                }
                if (rhsIdxs == null) {
                    return 1;
                }
                DimensionIndexer indexer = this.dimensionDescs.get(index).getIndexer();
                retVal = indexer.compareUnsortedEncodedKeyComponents(lhsIdxs, rhsIdxs);
                ++index;
            }
            if (retVal == 0) {
                int lengthDiff = Ints.compare(lhs.dims.length, rhs.dims.length);
                if (lengthDiff == 0) {
                    return 0;
                }
                Object[] largerDims = lengthDiff > 0 ? lhs.dims : rhs.dims;
                return IncrementalIndex.allNull(largerDims, numComparisons) ? 0 : lengthDiff;
            }
            return retVal;
        }
    }

    public static final class TimeAndDims {
        public static final int EMPTY_ROW_INDEX = -1;
        private final long timestamp;
        private final Object[] dims;
        private final List<DimensionDesc> dimensionDescsList;
        private int rowIndex;

        TimeAndDims(long timestamp, Object[] dims, List<DimensionDesc> dimensionDescsList) {
            this(timestamp, dims, dimensionDescsList, -1);
        }

        TimeAndDims(long timestamp, Object[] dims, List<DimensionDesc> dimensionDescsList, int rowIndex) {
            this.timestamp = timestamp;
            this.dims = dims;
            this.dimensionDescsList = dimensionDescsList;
            this.rowIndex = rowIndex;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Object[] getDims() {
            return this.dims;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        private void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public String toString() {
            return "TimeAndDims{timestamp=" + new DateTime(this.timestamp) + ", dims=" + Lists.transform(Arrays.asList(this.dims), new Function<Object, Object>(){

                @Override
                public Object apply(@Nullable Object input) {
                    if (input == null || Array.getLength(input) == 0) {
                        return Collections.singletonList("null");
                    }
                    return Collections.singletonList(input);
                }
            }) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeAndDims that = (TimeAndDims)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (this.dims.length != that.dims.length) {
                return false;
            }
            for (int i = 0; i < this.dims.length; ++i) {
                DimensionIndexer indexer = this.dimensionDescsList.get(i).getIndexer();
                if (indexer.checkUnsortedEncodedKeyComponentsEqual(this.dims[i], that.dims[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = (int)this.timestamp;
            for (int i = 0; i < this.dims.length; ++i) {
                DimensionIndexer indexer = this.dimensionDescsList.get(i).getIndexer();
                hash = 31 * hash + indexer.getUnsortedEncodedKeyComponentHashCode(this.dims[i]);
            }
            return hash;
        }
    }

    public static final class MetricDesc {
        private final int index;
        private final String name;
        private final String type;
        private final ColumnCapabilitiesImpl capabilities;

        public MetricDesc(int index, AggregatorFactory factory) {
            this.index = index;
            this.name = factory.getName();
            String typeInfo = factory.getTypeName();
            this.capabilities = new ColumnCapabilitiesImpl();
            if (typeInfo.equalsIgnoreCase("float")) {
                this.capabilities.setType(ValueType.FLOAT);
                this.type = typeInfo;
            } else if (typeInfo.equalsIgnoreCase("long")) {
                this.capabilities.setType(ValueType.LONG);
                this.type = typeInfo;
            } else if (typeInfo.equalsIgnoreCase("double")) {
                this.capabilities.setType(ValueType.DOUBLE);
                this.type = typeInfo;
            } else {
                this.capabilities.setType(ValueType.COMPLEX);
                this.type = ComplexMetrics.getSerdeForType(typeInfo).getTypeName();
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ColumnCapabilitiesImpl getCapabilities() {
            return this.capabilities;
        }
    }

    public static final class DimensionDesc {
        private final int index;
        private final String name;
        private final ColumnCapabilitiesImpl capabilities;
        private final DimensionHandler handler;
        private final DimensionIndexer indexer;

        public DimensionDesc(int index, String name, ColumnCapabilitiesImpl capabilities, DimensionHandler handler) {
            this.index = index;
            this.name = name;
            this.capabilities = capabilities;
            this.handler = handler;
            this.indexer = handler.makeIndexer();
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public ColumnCapabilitiesImpl getCapabilities() {
            return this.capabilities;
        }

        public DimensionHandler getHandler() {
            return this.handler;
        }

        public DimensionIndexer getIndexer() {
            return this.indexer;
        }
    }

    public static class Builder {
        private IncrementalIndexSchema incrementalIndexSchema = null;
        private boolean deserializeComplexMetrics = true;
        private boolean reportParseExceptions = true;
        private boolean concurrentEventAdd = false;
        private boolean sortFacts = true;
        private int maxRowCount = 0;

        public Builder setIndexSchema(IncrementalIndexSchema incrementalIndexSchema) {
            this.incrementalIndexSchema = incrementalIndexSchema;
            return this;
        }

        @VisibleForTesting
        public Builder setSimpleTestingIndexSchema(AggregatorFactory ... metrics) {
            this.incrementalIndexSchema = new IncrementalIndexSchema.Builder().withMetrics(metrics).build();
            return this;
        }

        public Builder setDeserializeComplexMetrics(boolean deserializeComplexMetrics) {
            this.deserializeComplexMetrics = deserializeComplexMetrics;
            return this;
        }

        public Builder setReportParseExceptions(boolean reportParseExceptions) {
            this.reportParseExceptions = reportParseExceptions;
            return this;
        }

        public Builder setConcurrentEventAdd(boolean concurrentEventAdd) {
            this.concurrentEventAdd = concurrentEventAdd;
            return this;
        }

        public Builder setSortFacts(boolean sortFacts) {
            this.sortFacts = sortFacts;
            return this;
        }

        public Builder setMaxRowCount(int maxRowCount) {
            this.maxRowCount = maxRowCount;
            return this;
        }

        public IncrementalIndex buildOnheap() {
            if (this.maxRowCount <= 0) {
                throw new IllegalArgumentException("Invalid max row count: " + this.maxRowCount);
            }
            return new OnheapIncrementalIndex(Objects.requireNonNull(this.incrementalIndexSchema, "incrementIndexSchema is null"), this.deserializeComplexMetrics, this.reportParseExceptions, this.concurrentEventAdd, this.sortFacts, this.maxRowCount);
        }

        public IncrementalIndex buildOffheap(NonBlockingPool<ByteBuffer> bufferPool) {
            if (this.maxRowCount <= 0) {
                throw new IllegalArgumentException("Invalid max row count: " + this.maxRowCount);
            }
            return new OffheapIncrementalIndex(Objects.requireNonNull(this.incrementalIndexSchema, "incrementalIndexSchema is null"), this.deserializeComplexMetrics, this.reportParseExceptions, this.concurrentEventAdd, this.sortFacts, this.maxRowCount, Objects.requireNonNull(bufferPool, "bufferPool is null"));
        }
    }
}

