/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.io.InputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.MultiValueIndexedIntsWriter;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;

public class VSizeIndexedWriter
extends MultiValueIndexedIntsWriter
implements Closeable {
    private static final byte VERSION = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final int maxId;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valuesOut = null;
    int numWritten = 0;
    private final IOPeon ioPeon;
    private final String metaFileName;
    private final String headerFileName;
    private final String valuesFileName;

    public VSizeIndexedWriter(IOPeon ioPeon, String filenameBase, int maxId) {
        this.ioPeon = ioPeon;
        this.metaFileName = StringUtils.format("%s.meta", filenameBase);
        this.headerFileName = StringUtils.format("%s.header", filenameBase);
        this.valuesFileName = StringUtils.format("%s.values", filenameBase);
        this.maxId = maxId;
    }

    @Override
    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.headerFileName));
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.valuesFileName));
    }

    @Override
    protected void addValues(List<Integer> val) throws IOException {
        this.write(val);
    }

    public void write(List<Integer> ints) throws IOException {
        byte[] bytesToWrite = ints == null ? EMPTY_ARRAY : VSizeIndexedInts.getBytesNoPaddingFromList(ints, this.maxId);
        this.valuesOut.write(bytesToWrite);
        this.headerOut.write(Ints.toByteArray((int)this.valuesOut.getCount()));
        ++this.numWritten;
    }

    @Override
    public void close() throws IOException {
        byte numBytesForMax = VSizeIndexedInts.getNumBytesForMax(this.maxId);
        this.valuesOut.write(new byte[4 - numBytesForMax]);
        Closeables.close(this.headerOut, false);
        Closeables.close(this.valuesOut, false);
        long numBytesWritten = this.headerOut.getCount() + this.valuesOut.getCount();
        Preconditions.checkState(this.headerOut.getCount() == (long)(this.numWritten * 4), "numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", this.numWritten, this.numWritten * 4, this.headerOut.getCount());
        Preconditions.checkState(numBytesWritten < Integer.MAX_VALUE, "Wrote[%s] bytes, which is too many.", numBytesWritten);
        try (OutputStream metaOut = this.ioPeon.makeOutputStream(this.metaFileName);){
            metaOut.write(new byte[]{1, numBytesForMax});
            metaOut.write(Ints.toByteArray((int)numBytesWritten + 4));
            metaOut.write(Ints.toByteArray(this.numWritten));
        }
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join(Iterables.transform(Arrays.asList(this.metaFileName, this.headerFileName, this.valuesFileName), new Function<String, InputSupplier<InputStream>>(){

            @Override
            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    @Override
                    public InputStream getInput() throws IOException {
                        return VSizeIndexedWriter.this.ioPeon.makeInputStream(input);
                    }
                };
            }
        }));
    }

    @Override
    public long getSerializedSize() {
        return 10L + this.headerOut.getCount() + this.valuesOut.getCount();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        try (ReadableByteChannel from = Channels.newChannel(this.combineStreams().getInput());){
            ByteStreams.copy(from, channel);
        }
    }
}

