/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.io.ZeroCopyByteArrayOutputStream;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;

public class VSizeIndexed
implements IndexedMultivalue<IndexedInts> {
    private static final byte version = 1;
    private final ByteBuffer theBuffer;
    private final int numBytes;
    private final int size;
    private final int valuesOffset;
    private final int bufferBytes;

    public static VSizeIndexed fromIterable(Iterable<VSizeIndexedInts> objectsIterable) {
        Iterator<VSizeIndexedInts> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0);
            buffer.flip();
            return new VSizeIndexed(buffer, 4);
        }
        int numBytes = -1;
        int count = 0;
        while (objects.hasNext()) {
            VSizeIndexedInts next = objects.next();
            if (numBytes == -1) {
                numBytes = next.getNumBytes();
            }
            ++count;
        }
        ZeroCopyByteArrayOutputStream headerBytes = new ZeroCopyByteArrayOutputStream(4 + count * 4);
        ZeroCopyByteArrayOutputStream valueBytes = new ZeroCopyByteArrayOutputStream();
        ByteBuffer helperBuffer = ByteBuffer.allocate(4);
        int offset = 0;
        try {
            SerializerUtils.writeBigEndianIntToOutputStream(headerBytes, count, helperBuffer);
            for (VSizeIndexedInts object : objectsIterable) {
                if (object.getNumBytes() != numBytes) {
                    throw new ISE("val.numBytes[%s] != numBytesInValue[%s]", object.getNumBytes(), numBytes);
                }
                byte[] bytes = object.getBytesNoPadding();
                SerializerUtils.writeBigEndianIntToOutputStream(headerBytes, offset += bytes.length, helperBuffer);
                valueBytes.write(bytes);
            }
            valueBytes.write(new byte[4 - numBytes]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer theBuffer = ByteBuffer.allocate(headerBytes.size() + valueBytes.size());
        headerBytes.writeTo(theBuffer);
        valueBytes.writeTo(theBuffer);
        theBuffer.flip();
        return new VSizeIndexed(theBuffer.asReadOnlyBuffer(), numBytes);
    }

    VSizeIndexed(ByteBuffer buffer, int numBytes) {
        this.theBuffer = buffer;
        this.numBytes = numBytes;
        this.size = this.theBuffer.getInt();
        this.valuesOffset = this.theBuffer.position() + (this.size << 2);
        this.bufferBytes = 4 - numBytes;
    }

    @Override
    public Class<? extends VSizeIndexedInts> getClazz() {
        return VSizeIndexedInts.class;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public VSizeIndexedInts get(int index) {
        int endOffset;
        if (index >= this.size) {
            throw new IAE("Index[%d] >= size[%d]", index, this.size);
        }
        ByteBuffer myBuffer = this.theBuffer.asReadOnlyBuffer();
        int startOffset = 0;
        if (index == 0) {
            endOffset = myBuffer.getInt();
        } else {
            myBuffer.position(myBuffer.position() + (index - 1) * 4);
            startOffset = myBuffer.getInt();
            endOffset = myBuffer.getInt();
        }
        myBuffer.position(this.valuesOffset + startOffset);
        myBuffer.limit(myBuffer.position() + (endOffset - startOffset) + this.bufferBytes);
        return myBuffer.hasRemaining() ? new VSizeIndexedInts(myBuffer, this.numBytes) : null;
    }

    @Override
    public int indexOf(IndexedInts value) {
        throw new UnsupportedOperationException("Reverse lookup not allowed.");
    }

    public int getSerializedSize() {
        return this.theBuffer.remaining() + 4 + 4 + 2;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.theBuffer.remaining() + 4)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.size)));
        channel.write(this.theBuffer.asReadOnlyBuffer());
    }

    public static VSizeIndexed readFromByteBuffer(ByteBuffer buffer) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            byte numBytes = buffer.get();
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new VSizeIndexed(bufferToUse, numBytes);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @Override
    public Iterator<IndexedInts> iterator() {
        return IndexedIterable.create(this).iterator();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("theBuffer", this.theBuffer);
    }

    public WritableSupplier<IndexedMultivalue<IndexedInts>> asWritableSupplier() {
        return new VSizeIndexedSupplier(this);
    }

    public static class VSizeIndexedSupplier
    implements WritableSupplier<IndexedMultivalue<IndexedInts>> {
        final VSizeIndexed delegate;

        public VSizeIndexedSupplier(VSizeIndexed delegate) {
            this.delegate = delegate;
        }

        @Override
        public long getSerializedSize() {
            return this.delegate.getSerializedSize();
        }

        @Override
        public void writeToChannel(WritableByteChannel channel) throws IOException {
            this.delegate.writeToChannel(channel);
        }

        @Override
        public IndexedMultivalue<IndexedInts> get() {
            return this.delegate;
        }
    }
}

