/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.VSizeLongSerde;

public class TableLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final Long2IntMap table;
    private final LongList valueAddedInOrder;
    private final int bitsPerValue;
    private VSizeLongSerde.LongSerializer serializer;

    public TableLongEncodingWriter(Long2IntMap table, LongList valueAddedInOrder) {
        if (table.size() > 256) {
            throw new IAE("Invalid table size[%s]", table.size());
        }
        this.table = table;
        this.valueAddedInOrder = valueAddedInOrder;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(table.size());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(OutputStream output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(this.table.get(value));
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }

    @Override
    public void putMeta(OutputStream metaOut, CompressedObjectStrategy.CompressionStrategy strategy) throws IOException {
        metaOut.write(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.write(CompressionFactory.LongEncodingFormat.TABLE.getId());
        metaOut.write(1);
        metaOut.write(Ints.toByteArray(this.table.size()));
        ByteBuffer helperBuffer = ByteBuffer.allocate(8);
        for (int i = 0; i < this.valueAddedInOrder.size(); ++i) {
            SerializerUtils.writeBigEndianLongToOutputStream(metaOut, this.valueAddedInOrder.getLong(i), helperBuffer);
        }
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }
}

