/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.io.druid.segment.historical.HistoricalColumnSelector;

public interface IndexedFloats
extends Closeable {
    public int size();

    public float get(int var1);

    public void fill(int var1, float[] var2);

    @Override
    public void close();

    default public FloatColumnSelector makeFloatColumnSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        class HistoricalFloatColumnSelector
        implements FloatColumnSelector,
        HistoricalColumnSelector {
            HistoricalFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                return IndexedFloats.this.get(offset.getOffset());
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                return IndexedFloats.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("indexed", IndexedFloats.this);
                inspector.visit("offset", offset);
            }
        }
        return new HistoricalFloatColumnSelector();
    }

    default public DoubleColumnSelector makeDoubleColumnSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        class HistoricalDoubleColumnSelector
        implements DoubleColumnSelector,
        HistoricalColumnSelector {
            HistoricalDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                return IndexedFloats.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                return IndexedFloats.this.get(offset2);
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("indexed", IndexedFloats.this);
                inspector.visit("offset", offset);
            }
        }
        return new HistoricalDoubleColumnSelector();
    }

    default public LongColumnSelector makeLongColumnSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        class HistoricalLongColumnSelector
        implements LongColumnSelector,
        HistoricalColumnSelector {
            HistoricalLongColumnSelector() {
            }

            @Override
            public long getLong() {
                return (long)IndexedFloats.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                return IndexedFloats.this.get(offset2);
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("indexed", IndexedFloats.this);
                inspector.visit("offset", offset);
            }
        }
        return new HistoricalLongColumnSelector();
    }
}

