/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.FixedSizeCompressedObjectStrategy;

public class CompressedIntBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<IntBuffer> {
    public static CompressedIntBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedIntBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedIntBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<IntBuffer>(){

            @Override
            public IntBuffer convert(ByteBuffer buf) {
                return buf.asIntBuffer();
            }

            @Override
            public int compare(IntBuffer lhs, IntBuffer rhs) {
                return Comparators.naturalNullsFirst().compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 4;
            }

            @Override
            public IntBuffer combine(ByteBuffer into, IntBuffer from) {
                return into.asIntBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

