/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.FixedSizeCompressedObjectStrategy;

public class CompressedDoubleBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<DoubleBuffer> {
    public static CompressedDoubleBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int size) {
        return new CompressedDoubleBufferObjectStrategy(order, compression, size);
    }

    private CompressedDoubleBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<DoubleBuffer>(){

            @Override
            public DoubleBuffer convert(ByteBuffer buf) {
                return buf.asDoubleBuffer();
            }

            @Override
            public int compare(DoubleBuffer lhs, DoubleBuffer rhs) {
                return Comparators.naturalNullsFirst().compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 8;
            }

            @Override
            public DoubleBuffer combine(ByteBuffer into, DoubleBuffer from) {
                return into.asDoubleBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

