/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.io.InputSupplier;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class ByteBufferWriter<T>
implements Closeable {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valueOut = null;
    private final ByteBuffer helperBuffer = ByteBuffer.allocate(4);

    public ByteBufferWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header")));
        this.valueOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("value")));
    }

    public void write(T objectToWrite) throws IOException {
        byte[] bytesToWrite = this.strategy.toBytes(objectToWrite);
        int length = bytesToWrite == null ? -1 : bytesToWrite.length;
        SerializerUtils.writeBigEndianIntToOutputStream(this.headerOut, length, this.helperBuffer);
        if (bytesToWrite != null) {
            this.valueOut.write(bytesToWrite);
        }
    }

    private String makeFilename(String suffix) {
        return StringUtils.format("%s.%s", this.filenameBase, suffix);
    }

    @Override
    public void close() throws IOException {
        this.headerOut.close();
        this.valueOut.close();
        long numBytesWritten = this.headerOut.getCount() + this.valueOut.getCount();
        Preconditions.checkState(numBytesWritten < Integer.MAX_VALUE, "Wrote[%s] bytes, which is too many.", numBytesWritten);
    }

    public long getSerializedSize() {
        return this.headerOut.getCount() + this.valueOut.getCount();
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join(Iterables.transform(Arrays.asList("header", "value"), new Function<String, InputSupplier<InputStream>>(){

            @Override
            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    @Override
                    public InputStream getInput() throws IOException {
                        return ByteBufferWriter.this.ioPeon.makeInputStream(ByteBufferWriter.this.makeFilename(input));
                    }
                };
            }
        }));
    }

    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        try (ReadableByteChannel from = Channels.newChannel(this.combineStreams().getInput());){
            ByteStreams.copy(from, channel);
        }
    }
}

