/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.RunLengthColumn;
import org.apache.hive.druid.io.druid.segment.column.SpatialIndex;

class SimpleColumn
implements Column {
    private final ColumnCapabilities capabilities;
    private final Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn;
    private final Supplier<RunLengthColumn> runLengthColumn;
    private final Supplier<GenericColumn> genericColumn;
    private final Supplier<ComplexColumn> complexColumn;
    private final Supplier<BitmapIndex> bitmapIndex;
    private final Supplier<SpatialIndex> spatialIndex;
    private final Supplier<ImmutableBitmap> nullValueBitmap;

    SimpleColumn(ColumnCapabilities capabilities, Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn, Supplier<RunLengthColumn> runLengthColumn, Supplier<GenericColumn> genericColumn, Supplier<ComplexColumn> complexColumn, Supplier<BitmapIndex> bitmapIndex, Supplier<SpatialIndex> spatialIndex, Supplier<ImmutableBitmap> nullValueBitmap) {
        this.capabilities = capabilities;
        this.dictionaryEncodedColumn = dictionaryEncodedColumn;
        this.runLengthColumn = runLengthColumn;
        this.genericColumn = genericColumn;
        this.complexColumn = complexColumn;
        this.bitmapIndex = bitmapIndex;
        this.spatialIndex = spatialIndex;
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public int getLength() {
        try (GenericColumn column = this.genericColumn.get();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public DictionaryEncodedColumn getDictionaryEncoding() {
        return this.dictionaryEncodedColumn == null ? null : this.dictionaryEncodedColumn.get();
    }

    @Override
    public RunLengthColumn getRunLengthColumn() {
        return this.runLengthColumn == null ? null : this.runLengthColumn.get();
    }

    @Override
    public GenericColumn getGenericColumn() {
        return this.genericColumn == null ? null : this.genericColumn.get();
    }

    @Override
    public ComplexColumn getComplexColumn() {
        return this.complexColumn == null ? null : this.complexColumn.get();
    }

    @Override
    public BitmapIndex getBitmapIndex() {
        return this.bitmapIndex == null ? null : this.bitmapIndex.get();
    }

    @Override
    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex == null ? null : this.spatialIndex.get();
    }
}

