/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

public class LongDimensionIndexer
implements DimensionIndexer<Long, Long, Long> {
    public static final Comparator LONG_COMPARATOR = Comparators.naturalNullsFirst();

    @Override
    public ValueType getValueType() {
        return ValueType.LONG;
    }

    @Override
    public Long processRowValsToUnsortedEncodedKeyComponent(Object dimValues) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        return DimensionHandlerUtils.convertObjectToLong(dimValues);
    }

    @Override
    public Long getSortedEncodedValueFromUnsorted(Long unsortedIntermediateValue) {
        return unsortedIntermediateValue;
    }

    @Override
    public Long getUnsortedEncodedValueFromSorted(Long sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Long> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new LongWrappingDimensionSelector(this.makeLongColumnSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerLongColumnSelector
        implements LongColumnSelector {
            IndexerLongColumnSelector() {
            }

            @Override
            public long getLong() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0L;
                }
                return DimensionHandlerUtils.nullToZero((Long)dims[dimIndex]);
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerLongColumnSelector();
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerFloatColumnSelector
        implements FloatColumnSelector {
            IndexerFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0f;
                }
                return DimensionHandlerUtils.nullToZero((Long)dims[dimIndex]).longValue();
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerFloatColumnSelector();
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerDoubleColumnSelector
        implements DoubleColumnSelector {
            IndexerDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                Object[] dims = currEntry.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0;
                }
                return DimensionHandlerUtils.nullToZero((Long)dims[dimIndex]).longValue();
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.getKey().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDoubleColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Long lhs, @Nullable Long rhs) {
        return LONG_COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Long lhs, @Nullable Long rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Long key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Long key, boolean asList) {
        return key;
    }

    @Override
    public Long convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Long key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Long key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

