/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.LongSupplierSerializer;

public class LongColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final CompressionFactory.LongEncodingStrategy encoding;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private LongSupplierSerializer writer;
    private ByteBufferWriter<ImmutableBitmap> nullValueBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private int rowCount = 0;

    public static LongColumnSerializer create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding, BitmapSerdeFactory bitmapSerdeFactory) {
        return new LongColumnSerializer(ioPeon, filenameBase, IndexIO.BYTE_ORDER, compression, encoding, bitmapSerdeFactory);
    }

    public LongColumnSerializer(IOPeon ioPeon, String filenameBase, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding, BitmapSerdeFactory bitmapSerdeFactory) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.encoding = encoding;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getLongSerializer(this.ioPeon, StringUtils.format("%s.long_column", this.filenameBase), this.byteOrder, this.encoding, this.compression);
        this.writer.open();
        this.nullValueBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.ioPeon, StringUtils.format("%s.nullBitmap", this.filenameBase), this.bitmapSerdeFactory.getObjectStrategy());
        this.nullValueBitmapWriter.open();
        this.nullRowsBitmap = this.bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void serialize(@Nullable Object obj) throws IOException {
        if (obj == null) {
            this.nullRowsBitmap.add(this.rowCount);
            this.writer.add(0L);
        } else {
            this.writer.add(((Number)obj).longValue());
        }
        ++this.rowCount;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.nullValueBitmapWriter.write(this.bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(this.nullRowsBitmap));
        this.nullValueBitmapWriter.close();
    }

    @Override
    public long getSerializedSize() {
        long bitmapSize = this.nullRowsBitmap.isEmpty() ? 0L : this.nullValueBitmapWriter.getSerializedSize();
        return 4L + this.writer.getSerializedSize() + bitmapSize;
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.writer.getSerializedSize())));
        this.writer.writeToChannel(channel, smoosher);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.nullValueBitmapWriter.writeToChannel(channel, smoosher);
        }
    }
}

