/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.topn.types.TopNColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class TopNMapFn {
    private static Function<Object, Object> STRING_TRANSFORMER = input -> Objects.toString(input, null);
    private static Function<Object, Object> LONG_TRANSFORMER = input -> {
        Long longVal = DimensionHandlerUtils.convertObjectToLong(input);
        return longVal == null ? DimensionHandlerUtils.ZERO_LONG : longVal;
    };
    private static Function<Object, Object> FLOAT_TRANSFORMER = input -> DimensionHandlerUtils.convertObjectToFloat(input);
    private static Function<Object, Object> DOUBLE_TRANSFORMER = input -> DimensionHandlerUtils.convertObjectToDouble(input);
    private static final TopNColumnSelectorStrategyFactory STRATEGY_FACTORY = new TopNColumnSelectorStrategyFactory();
    private final TopNQuery query;
    private final TopNAlgorithm topNAlgorithm;

    public static Function<Object, Object> getValueTransformer(ValueType outputType) {
        switch (outputType) {
            case STRING: {
                return STRING_TRANSFORMER;
            }
            case LONG: {
                return LONG_TRANSFORMER;
            }
            case FLOAT: {
                return FLOAT_TRANSFORMER;
            }
            case DOUBLE: {
                return DOUBLE_TRANSFORMER;
            }
        }
        throw new IAE("invalid type: %s", new Object[]{outputType});
    }

    public TopNMapFn(TopNQuery query, TopNAlgorithm topNAlgorithm) {
        this.query = query;
        this.topNAlgorithm = topNAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<TopNResultValue> apply(Cursor cursor, @Nullable TopNQueryMetrics queryMetrics) {
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = DimensionHandlerUtils.createColumnSelectorPlus(STRATEGY_FACTORY, this.query.getDimensionSpec(), cursor.getColumnSelectorFactory());
        if (selectorPlus.getSelector() == null) {
            return null;
        }
        TopNParams params = null;
        try {
            params = this.topNAlgorithm.makeInitParams(selectorPlus, cursor);
            if (queryMetrics != null) {
                queryMetrics.columnValueSelector(selectorPlus.getSelector());
                queryMetrics.numValuesPerPass(params);
            }
            TopNResultBuilder resultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, this.query);
            this.topNAlgorithm.run(params, resultBuilder, null, queryMetrics);
            Result<TopNResultValue> result = resultBuilder.build();
            return result;
        }
        finally {
            this.topNAlgorithm.cleanup(params);
        }
    }
}

