/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import com.google.inject.Binder;
import java.util.List;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.guice.ExpressionModule;
import org.apache.hive.druid.io.druid.guice.Jerseys;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.initialization.DruidModule;
import org.apache.hive.druid.io.druid.query.expression.LookupExprMacro;
import org.apache.hive.druid.io.druid.query.lookup.LookupConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectionResource;
import org.apache.hive.druid.io.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupListeningResource;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.LookupResourceListenerAnnouncer;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyBindings;

public class LookupModule
implements DruidModule {
    static final String PROPERTY_BASE = "druid.lookup";
    public static final String FAILED_UPDATES_KEY = "failedUpdates";

    public static String getTierListenerPath(String tier) {
        return ZKPaths.makePath((String)"lookups", (String)tier);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of(new SimpleModule("DruidLookupModule").registerSubtypes(MapLookupExtractorFactory.class));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, PROPERTY_BASE, LookupConfig.class);
        LifecycleModule.register(binder, LookupReferencesManager.class);
        JsonConfigProvider.bind(binder, PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        Jerseys.addResource(binder, LookupListeningResource.class);
        Jerseys.addResource(binder, LookupIntrospectionResource.class);
        ExpressionModule.addExprMacro(binder, LookupExprMacro.class);
        LifecycleModule.register(binder, LookupResourceListenerAnnouncer.class);
        binder.bind(LookupResourceListenerAnnouncer.class).in(ManageLifecycle.class);
        JettyBindings.addQosFilter(binder, "/druid/listen/v1/lookups", 2);
    }
}

