/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.strategy;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.GroupByMergedQueryRunner;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryEngine;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryHelper;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.joda.time.Interval;

public class GroupByStrategyV1
implements GroupByStrategy {
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;
    private final NonBlockingPool<ByteBuffer> bufferPool;

    @Inject
    public GroupByStrategyV1(Supplier<GroupByQueryConfig> configSupplier, GroupByQueryEngine engine, QueryWatcher queryWatcher, @Global NonBlockingPool<ByteBuffer> bufferPool) {
        this.configSupplier = configSupplier;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
        this.bufferPool = bufferPool;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query, boolean willMergeRunners) {
        return new GroupByQueryResource();
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return true;
    }

    @Override
    public QueryRunner<Row> createIntervalChunkingRunner(IntervalChunkingQueryRunnerDecorator decorator, QueryRunner<Row> runner, GroupByQueryQueryToolChest toolChest) {
        return decorator.decorate(runner, toolChest);
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return query.getContextBoolean("groupByMerge", true);
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, GroupByQuery query, Map<String, Object> responseContext) {
        IncrementalIndex index = GroupByQueryHelper.makeIncrementalIndex(query, this.configSupplier.get(), this.bufferPool, baseRunner.run(QueryPlus.wrap(new GroupByQuery.Builder(query).setPostAggregatorSpecs(ImmutableList.of()).setHavingSpec(null).setLimitSpec(NoopLimitSpec.instance()).overrideContext(ImmutableMap.of("finalize", false, "sortResults", false, "groupByMerge", false, "groupByStrategy", "v1")).build()), responseContext), true);
        return Sequences.withBaggage(query.postProcess(GroupByQueryHelper.postAggregate(query, index)), index);
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<Row> subqueryResult) {
        HashSet<AggregatorFactory> aggs = Sets.newHashSet();
        HashSet<String> dimensionNames = Sets.newHashSet();
        for (DimensionSpec dimension : subquery.getDimensions()) {
            dimensionNames.add(dimension.getOutputName());
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            for (final AggregatorFactory transferAgg : aggregatorFactory.getRequiredColumns()) {
                if (dimensionNames.contains(transferAgg.getName())) continue;
                if (Iterables.any(aggs, new Predicate<AggregatorFactory>(){

                    @Override
                    public boolean apply(AggregatorFactory agg) {
                        return agg.getName().equals(transferAgg.getName()) && !agg.equals(transferAgg);
                    }
                })) {
                    throw new IAE("Inner aggregator can currently only be referenced by a single type of outer aggregator for '%s'", transferAgg.getName());
                }
                aggs.add(transferAgg);
            }
        }
        GroupByQuery innerQuery = new GroupByQuery.Builder(subquery).setAggregatorSpecs(Lists.newArrayList(aggs)).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(Lists.newArrayList()).build();
        final GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
        final IncrementalIndex innerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex((GroupByQuery)innerQuery.withOverriddenContext(ImmutableMap.of("sortResults", true)), this.configSupplier.get(), this.bufferPool, subqueryResult, false);
        IncrementalIndex outerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex(outerQuery, this.configSupplier.get(), this.bufferPool, Sequences.concat(Sequences.map(Sequences.simple(outerQuery.getIntervals()), new Function<Interval, Sequence<Row>>(){

            @Override
            public Sequence<Row> apply(Interval interval) {
                return GroupByStrategyV1.this.process(outerQuery.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(ImmutableList.of(interval))), new IncrementalIndexStorageAdapter(innerQueryResultIndex));
            }
        })), true);
        innerQueryResultIndex.close();
        return Sequences.withBaggage(outerQuery.postProcess(GroupByQueryHelper.postAggregate(query, outerQueryResultIndex)), outerQueryResultIndex);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergedQueryRunner<Row>(exec, this.configSupplier, this.queryWatcher, this.bufferPool, queryRunners);
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return this.engine.process(query, storageAdapter);
    }
}

