/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class StringGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap) {
        int id = key.getInt(selectorPlus.getKeyBufferPosition());
        if (id != -1) {
            resultMap.put(selectorPlus.getOutputName(), ((DimensionSelector)selectorPlus.getSelector()).lookupName(id));
        } else {
            resultMap.put(selectorPlus.getOutputName(), NullHandlingHelper.nullToDefault((String)null));
        }
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        valuess[columnIndex] = row;
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState(row.size() < 2, "Not supported for multi-value dimensions");
        return row.size() == 1 ? row.get(0) : -1;
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putInt(keyBufferPosition, (Integer)obj);
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        this.initializeGroupingKeyV2Dimension(row, rowSize, keyBuffer, keyBufferPosition);
        stack[columnIndex] = rowSize == 0 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        if (rowValIdx < rowSize) {
            keyBuffer.putInt(keyBufferPosition, row.get(rowValIdx));
            return true;
        }
        return false;
    }

    private void initializeGroupingKeyV2Dimension(IndexedInts values, int rowSize, ByteBuffer keyBuffer, int keyBufferPosition) {
        if (rowSize == 0) {
            keyBuffer.putInt(keyBufferPosition, -1);
        } else {
            keyBuffer.putInt(keyBufferPosition, values.get(0));
        }
    }
}

