/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.TemporaryStorageFullException;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class SpillingGrouper<KeyType>
implements Grouper<KeyType> {
    private final Grouper<KeyType> grouper;
    private static final AggregateResult DISK_FULL = AggregateResult.failure("Not enough disk space to execute this query. Try raising druid.query.groupBy.maxOnDiskStorage.");
    private final Grouper.KeySerde<KeyType> keySerde;
    private final LimitedTemporaryStorage temporaryStorage;
    private final ObjectMapper spillMapper;
    private final AggregatorFactory[] aggregatorFactories;
    private final Comparator<Grouper.Entry<KeyType>> keyObjComparator;
    private final Comparator<Grouper.Entry<KeyType>> defaultOrderKeyObjComparator;
    private final List<File> files = Lists.newArrayList();
    private final List<Closeable> closeables = Lists.newArrayList();
    private final boolean sortHasNonGroupingFields;
    private boolean spillingAllowed = false;

    public SpillingGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, boolean spillingAllowed, DefaultLimitSpec limitSpec, boolean sortHasNonGroupingFields) {
        this.keySerde = keySerdeFactory.factorize();
        this.keyObjComparator = keySerdeFactory.objectComparator(false);
        this.defaultOrderKeyObjComparator = keySerdeFactory.objectComparator(true);
        this.grouper = limitSpec != null ? new LimitedBufferHashGrouper<KeyType>(bufferSupplier, this.keySerde, columnSelectorFactory, aggregatorFactories, bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets, limitSpec.getLimit(), sortHasNonGroupingFields) : new BufferHashGrouper<KeyType>(bufferSupplier, this.keySerde, columnSelectorFactory, aggregatorFactories, bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets);
        this.aggregatorFactories = aggregatorFactories;
        this.temporaryStorage = temporaryStorage;
        this.spillMapper = spillMapper;
        this.spillingAllowed = spillingAllowed;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
    }

    @Override
    public void init() {
        this.grouper.init();
    }

    @Override
    public boolean isInitialized() {
        return this.grouper.isInitialized();
    }

    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        AggregateResult result = this.grouper.aggregate(key, keyHash);
        if (result.isOk() || this.temporaryStorage.maxSize() <= 0L || !this.spillingAllowed) {
            return result;
        }
        try {
            this.spill();
        }
        catch (TemporaryStorageFullException e) {
            return DISK_FULL;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        return this.grouper.aggregate(key, keyHash);
    }

    @Override
    public void reset() {
        this.grouper.reset();
        this.deleteFiles();
    }

    @Override
    public void close() {
        this.grouper.close();
        this.deleteFiles();
    }

    public void setSpillingAllowed(boolean spillingAllowed) {
        this.spillingAllowed = spillingAllowed;
    }

    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        ArrayList iterators = new ArrayList(1 + this.files.size());
        iterators.add(this.grouper.iterator(sorted));
        for (File file : this.files) {
            MappingIterator<Grouper.Entry<KeyType>> fileIterator = this.read(file, this.keySerde.keyClazz());
            iterators.add(Iterators.transform(fileIterator, new Function<Grouper.Entry<KeyType>, Grouper.Entry<KeyType>>(){

                @Override
                public Grouper.Entry<KeyType> apply(Grouper.Entry<KeyType> entry) {
                    Object[] deserializedValues = new Object[entry.getValues().length];
                    for (int i = 0; i < deserializedValues.length; ++i) {
                        deserializedValues[i] = SpillingGrouper.this.aggregatorFactories[i].deserialize(entry.getValues()[i]);
                        if (!(deserializedValues[i] instanceof Integer)) continue;
                        deserializedValues[i] = ((Integer)deserializedValues[i]).longValue();
                    }
                    return new Grouper.Entry(entry.getKey(), deserializedValues);
                }
            }));
            this.closeables.add(fileIterator);
        }
        if (this.sortHasNonGroupingFields) {
            return Groupers.mergeIterators(iterators, this.defaultOrderKeyObjComparator);
        }
        return Groupers.mergeIterators(iterators, sorted ? this.keyObjComparator : null);
    }

    private void spill() throws IOException {
        File outFile;
        try (LimitedTemporaryStorage.LimitedOutputStream out = this.temporaryStorage.createFile();
             LZ4BlockOutputStream compressedOut = new LZ4BlockOutputStream(out);
             JsonGenerator jsonGenerator = this.spillMapper.getFactory().createGenerator(compressedOut);){
            outFile = out.getFile();
            Iterator<Grouper.Entry<KeyType>> it = this.grouper.iterator(true);
            while (it.hasNext()) {
                BaseQuery.checkInterrupted();
                jsonGenerator.writeObject(it.next());
            }
        }
        this.files.add(outFile);
        this.grouper.reset();
    }

    private MappingIterator<Grouper.Entry<KeyType>> read(File file, Class<KeyType> keyClazz) {
        try {
            return this.spillMapper.readValues(this.spillMapper.getFactory().createParser(new LZ4BlockInputStream(new FileInputStream(file))), this.spillMapper.getTypeFactory().constructParametricType(Grouper.Entry.class, keyClazz));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private void deleteFiles() {
        for (Closeable closeable : this.closeables) {
            CloseQuietly.close(closeable);
        }
        for (File file : this.files) {
            this.temporaryStorage.delete(file);
        }
        this.files.clear();
    }
}

