/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class ConcurrentGrouper<KeyType>
implements Grouper<KeyType> {
    private final List<SpillingGrouper<KeyType>> groupers;
    private final ThreadLocal<SpillingGrouper<KeyType>> threadLocalGrouper;
    private final AtomicInteger threadNumber = new AtomicInteger();
    private volatile boolean spilling = false;
    private volatile boolean closed = false;
    private final Comparator<Grouper.Entry<KeyType>> keyObjComparator;
    private final Supplier<ByteBuffer> bufferSupplier;
    private final ColumnSelectorFactory columnSelectorFactory;
    private final AggregatorFactory[] aggregatorFactories;
    private final int bufferGrouperMaxSize;
    private final float bufferGrouperMaxLoadFactor;
    private final int bufferGrouperInitialBuckets;
    private final LimitedTemporaryStorage temporaryStorage;
    private final ObjectMapper spillMapper;
    private final int concurrencyHint;
    private final Grouper.KeySerdeFactory<KeyType> keySerdeFactory;
    private final DefaultLimitSpec limitSpec;
    private final boolean sortHasNonGroupingFields;
    private volatile boolean initialized = false;

    public ConcurrentGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, int concurrencyHint, DefaultLimitSpec limitSpec, boolean sortHasNonGroupingFields) {
        Preconditions.checkArgument(concurrencyHint > 0, "concurrencyHint > 0");
        this.groupers = new ArrayList<SpillingGrouper<KeyType>>(concurrencyHint);
        this.threadLocalGrouper = new ThreadLocal<SpillingGrouper<KeyType>>(){

            @Override
            protected SpillingGrouper<KeyType> initialValue() {
                return (SpillingGrouper)ConcurrentGrouper.this.groupers.get(ConcurrentGrouper.this.threadNumber.getAndIncrement());
            }
        };
        this.bufferSupplier = bufferSupplier;
        this.columnSelectorFactory = columnSelectorFactory;
        this.aggregatorFactories = aggregatorFactories;
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
        this.bufferGrouperMaxLoadFactor = bufferGrouperMaxLoadFactor;
        this.bufferGrouperInitialBuckets = bufferGrouperInitialBuckets;
        this.temporaryStorage = temporaryStorage;
        this.spillMapper = spillMapper;
        this.concurrencyHint = concurrencyHint;
        this.keySerdeFactory = keySerdeFactory;
        this.limitSpec = limitSpec;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
        this.keyObjComparator = keySerdeFactory.objectComparator(sortHasNonGroupingFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.initialized) {
            Supplier<ByteBuffer> supplier = this.bufferSupplier;
            synchronized (supplier) {
                if (!this.initialized) {
                    ByteBuffer buffer = this.bufferSupplier.get();
                    int sliceSize = buffer.capacity() / this.concurrencyHint;
                    for (int i = 0; i < this.concurrencyHint; ++i) {
                        ByteBuffer slice = buffer.duplicate();
                        slice.position(sliceSize * i);
                        slice.limit(slice.position() + sliceSize);
                        SpillingGrouper<KeyType> grouper = new SpillingGrouper<KeyType>(Suppliers.ofInstance(slice.slice()), this.keySerdeFactory, this.columnSelectorFactory, this.aggregatorFactories, this.bufferGrouperMaxSize, this.bufferGrouperMaxLoadFactor, this.bufferGrouperInitialBuckets, this.temporaryStorage, this.spillMapper, false, this.limitSpec, this.sortHasNonGroupingFields);
                        grouper.init();
                        this.groupers.add(grouper);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        SpillingGrouper<KeyType> tlGrouper;
        SpillingGrouper<KeyType> spillingGrouper;
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        if (!this.spilling) {
            SpillingGrouper<KeyType> hashBasedGrouper = this.groupers.get(this.grouperNumberForKeyHash(keyHash));
            spillingGrouper = hashBasedGrouper;
            synchronized (spillingGrouper) {
                if (!this.spilling) {
                    if (hashBasedGrouper.aggregate(key, keyHash).isOk()) {
                        return AggregateResult.ok();
                    }
                    this.spilling = true;
                }
            }
        }
        spillingGrouper = tlGrouper = this.threadLocalGrouper.get();
        synchronized (spillingGrouper) {
            tlGrouper.setSpillingAllowed(true);
            return tlGrouper.aggregate(key, keyHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                grouper.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        ArrayList iterators = new ArrayList(this.groupers.size());
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                iterators.add(grouper.iterator(sorted));
            }
        }
        return Groupers.mergeIterators(iterators, sorted ? this.keyObjComparator : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                grouper.close();
            }
        }
    }

    private int grouperNumberForKeyHash(int keyHash) {
        return keyHash % this.groupers.size();
    }
}

