/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Floats;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidDoublePredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.filter.InFilter;

public class InDimFilter
implements DimFilter {
    public static final int NUMERIC_HASHING_THRESHOLD = 16;
    private final SortedSet<String> values;
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") Collection<String> values, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkNotNull(dimension, "dimension can not be null");
        Preconditions.checkArgument(values != null && !values.isEmpty(), "values can not be null or empty");
        this.values = new TreeSet(Comparators.naturalNullsFirst());
        for (String value : values) {
            this.values.add(NullHandlingHelper.defaultToNull(value));
        }
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = this.getLongPredicateSupplier();
        this.floatPredicateSupplier = this.getFloatPredicateSupplier();
        this.doublePredicateSupplier = this.getDoublePredicateSupplier();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        boolean hasNull = false;
        for (String value : this.values) {
            if (value == null) {
                hasNull = true;
            }
            valuesBytes[index] = StringUtils.toUtf8(Strings.nullToEmpty(value));
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        ByteBuffer filterCacheKey = ByteBuffer.allocate(5 + dimensionBytes.length + valuesBytesSize + extractionFnBytes.length).put((byte)9).put(dimensionBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1).put(hasNull ? (byte)1 : 0).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, inFilter.values.first(), inFilter.getExtractionFn());
        }
        return inFilter;
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            ArrayList<String> keys = new ArrayList<String>();
            for (String value : this.values) {
                String convertedValue = Strings.emptyToNull(value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || !NullHandlingHelper.isNullOrDefault(lookup.apply(convertedValue))) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null);
        }
        return this;
    }

    @Override
    public Filter toFilter() {
        return new InFilter(this.dimension, this.values, this.longPredicateSupplier, this.floatPredicateSupplier, this.doublePredicateSupplier, this.extractionFn);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        for (String value : this.values) {
            retSet.add(Range.singleton(Strings.nullToEmpty(value)));
        }
        return retSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.values != null ? this.values.hashCode() : 0;
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.extractionFn != null) {
            builder.append(this.extractionFn).append("(");
        }
        builder.append(this.dimension);
        if (this.extractionFn != null) {
            builder.append(")");
        }
        builder.append(" IN (").append(Joiner.on(", ").join(Iterables.transform(this.values, input -> Strings.nullToEmpty(input)))).append(")");
        return builder.toString();
    }

    private Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        return new Supplier<DruidLongPredicate>(){
            private final Object initLock = new Object();
            private DruidLongPredicate predicate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initLongValues() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    if (this.predicate != null) {
                        return;
                    }
                    LongArrayList longs = new LongArrayList(InDimFilter.this.values.size());
                    for (String value : InDimFilter.this.values) {
                        Long longValue = DimensionHandlerUtils.getExactLongFromDecimalString(value);
                        if (longValue == null) continue;
                        longs.add(longValue);
                    }
                    if (longs.size() > 16) {
                        LongOpenHashSet longHashSet = new LongOpenHashSet(longs);
                        this.predicate = input -> longHashSet.contains(input);
                    } else {
                        long[] longArray = longs.toLongArray();
                        Arrays.sort(longArray);
                        this.predicate = input -> Arrays.binarySearch(longArray, input) >= 0;
                    }
                }
            }

            @Override
            public DruidLongPredicate get() {
                this.initLongValues();
                return this.predicate;
            }
        };
    }

    private Supplier<DruidFloatPredicate> getFloatPredicateSupplier() {
        return new Supplier<DruidFloatPredicate>(){
            private final Object initLock = new Object();
            private DruidFloatPredicate predicate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initFloatValues() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    if (this.predicate != null) {
                        return;
                    }
                    IntArrayList floatBits = new IntArrayList(InDimFilter.this.values.size());
                    for (String value : InDimFilter.this.values) {
                        Float floatValue = Floats.tryParse(value);
                        if (floatValue == null) continue;
                        floatBits.add(Float.floatToIntBits(floatValue.floatValue()));
                    }
                    if (floatBits.size() > 16) {
                        IntOpenHashSet floatBitsHashSet = new IntOpenHashSet(floatBits);
                        this.predicate = input -> floatBitsHashSet.contains(Float.floatToIntBits(input));
                    } else {
                        int[] floatBitsArray = floatBits.toIntArray();
                        Arrays.sort(floatBitsArray);
                        this.predicate = input -> Arrays.binarySearch(floatBitsArray, Float.floatToIntBits(input)) >= 0;
                    }
                }
            }

            @Override
            public DruidFloatPredicate get() {
                this.initFloatValues();
                return this.predicate;
            }
        };
    }

    private Supplier<DruidDoublePredicate> getDoublePredicateSupplier() {
        return new Supplier<DruidDoublePredicate>(){
            private final Object initLock = new Object();
            private DruidDoublePredicate predicate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initDoubleValues() {
                if (this.predicate != null) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    if (this.predicate != null) {
                        return;
                    }
                    LongArrayList doubleBits = new LongArrayList(InDimFilter.this.values.size());
                    for (String value : InDimFilter.this.values) {
                        Double doubleValue = Doubles.tryParse(value);
                        if (doubleValue == null) continue;
                        doubleBits.add(Double.doubleToLongBits(doubleValue));
                    }
                    if (doubleBits.size() > 16) {
                        LongOpenHashSet doubleBitsHashSet = new LongOpenHashSet(doubleBits);
                        this.predicate = input -> doubleBitsHashSet.contains(Double.doubleToLongBits(input));
                    } else {
                        long[] doubleBitsArray = doubleBits.toLongArray();
                        Arrays.sort(doubleBitsArray);
                        this.predicate = input -> Arrays.binarySearch(doubleBitsArray, Double.doubleToLongBits(input)) >= 0;
                    }
                }
            }

            @Override
            public DruidDoublePredicate get() {
                this.initDoubleValues();
                return this.predicate;
            }
        };
    }
}

