/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.filter.ExpressionFilter;

public class ExpressionDimFilter
implements DimFilter {
    private final String expression;
    private final Expr parsed;

    @JsonCreator
    public ExpressionDimFilter(@JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        this.expression = expression;
        this.parsed = Parser.parse(expression, macroTable);
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ExpressionFilter(this.parsed);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(14).appendString(this.expression).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionDimFilter that = (ExpressionDimFilter)o;
        return Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public String toString() {
        return "ExpressionDimFilter{expression='" + this.expression + '\'' + '}';
    }
}

