/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class LookupDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 4;
    @JsonProperty
    private final String dimension;
    @JsonProperty
    private final String outputName;
    @JsonProperty
    private final LookupExtractor lookup;
    @JsonProperty
    private final boolean retainMissingValue;
    @JsonProperty
    private final String replaceMissingValueWith;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final boolean optimize;
    private final LookupReferencesManager lookupReferencesManager;

    @JsonCreator
    public LookupDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="name") String name, @JacksonInject LookupReferencesManager lookupReferencesManager, @JsonProperty(value="optimize") Boolean optimize) {
        this.retainMissingValue = retainMissingValue;
        this.optimize = optimize == null ? true : optimize;
        this.replaceMissingValueWith = NullHandlingHelper.defaultToNull(replaceMissingValueWith);
        this.dimension = Preconditions.checkNotNull(dimension, "dimension can not be Null");
        this.outputName = Preconditions.checkNotNull(outputName, "outputName can not be Null");
        this.lookupReferencesManager = lookupReferencesManager;
        this.name = name;
        this.lookup = lookup;
        Preconditions.checkArgument(Strings.isNullOrEmpty(name) ^ lookup == null, "name [%s] and lookup [%s] are mutually exclusive please provide either a name or a lookup", name, lookup);
        if (!Strings.isNullOrEmpty(name)) {
            Preconditions.checkNotNull(this.lookupReferencesManager, "The system is not configured to allow for lookups, please read about configuring a lookup manager in the docs");
        }
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public ValueType getOutputType() {
        return ValueType.STRING;
    }

    @JsonProperty
    @Nullable
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        LookupExtractor lookupExtractor = Strings.isNullOrEmpty(this.name) ? this.lookup : (LookupExtractor)Preconditions.checkNotNull(this.lookupReferencesManager.get(this.name), "Lookup [%s] not found", this.name).getLookupExtractorFactory().get();
        return new LookupExtractionFn(lookupExtractor, this.retainMissingValue, this.replaceMissingValueWith, lookupExtractor.isOneToOne(), this.optimize);
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] dimExtractionFnBytes = Strings.isNullOrEmpty(this.name) ? this.getLookup().getCacheKey() : StringUtils.toUtf8(this.name);
        byte[] outputNameBytes = StringUtils.toUtf8(this.outputName);
        byte[] replaceWithBytes = StringUtils.toUtf8(Strings.nullToEmpty(this.replaceMissingValueWith));
        return ByteBuffer.allocate(7 + dimensionBytes.length + outputNameBytes.length + dimExtractionFnBytes.length + replaceWithBytes.length).put((byte)4).put(dimensionBytes).put((byte)-1).put(outputNameBytes).put((byte)-1).put(dimExtractionFnBytes).put((byte)-1).put(replaceWithBytes).put((byte)-1).put(this.retainMissingValue ? (byte)1 : 0).put(this.replaceMissingValueWith == null ? (byte)0 : 1).array();
    }

    @Override
    public boolean preservesOrdering() {
        return this.getExtractionFn().preservesOrdering();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupDimensionSpec)) {
            return false;
        }
        LookupDimensionSpec that = (LookupDimensionSpec)o;
        if (this.retainMissingValue != that.retainMissingValue) {
            return false;
        }
        if (this.optimize != that.optimize) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (!this.getOutputName().equals(that.getOutputName())) {
            return false;
        }
        if (this.getLookup() != null ? !this.getLookup().equals(that.getLookup()) : that.getLookup() != null) {
            return false;
        }
        if (this.replaceMissingValueWith != null ? !this.replaceMissingValueWith.equals(that.replaceMissingValueWith) : that.replaceMissingValueWith != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + this.getOutputName().hashCode();
        result = 31 * result + (this.getLookup() != null ? this.getLookup().hashCode() : 0);
        result = 31 * result + (this.retainMissingValue ? 1 : 0);
        result = 31 * result + (this.replaceMissingValueWith != null ? this.replaceMissingValueWith.hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.optimize ? 1 : 0);
        return result;
    }
}

