/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.last;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class DoubleLastAggregator
implements Aggregator {
    private final DoubleColumnSelector valueSelector;
    private final LongColumnSelector timeSelector;
    private final String name;
    protected long lastTime;
    protected double lastValue;

    public DoubleLastAggregator(String name, LongColumnSelector timeSelector, DoubleColumnSelector valueSelector) {
        this.name = name;
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.reset();
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            this.lastValue = this.valueSelector.getDouble();
        }
    }

    @Override
    public void reset() {
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = 0.0;
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Double>(this.lastTime, this.lastValue);
    }

    @Override
    public float getFloat() {
        return (float)this.lastValue;
    }

    @Override
    public long getLong() {
        return (long)this.lastValue;
    }

    @Override
    public double getDouble() {
        return this.lastValue;
    }

    @Override
    public void close() {
    }
}

