/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstBufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class FloatFirstAggregatorFactory
extends AggregatorFactory {
    public static final Comparator VALUE_COMPARATOR = (o1, o2) -> Doubles.compare(((Float)((SerializablePair)o1).rhs).floatValue(), ((Float)((SerializablePair)o2).rhs).floatValue());
    public static final Comparator TIME_COMPARATOR = (o1, o2) -> Longs.compare((Long)((SerializablePair)o1).lhs, (Long)((SerializablePair)o2).lhs);
    private final String fieldName;
    private final String name;

    @JsonCreator
    public FloatFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldName, "Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = metricFactory.makeFloatColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new FloatFirstAggregator(this.name, metricFactory.makeLongColumnSelector("__time"), floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = metricFactory.makeFloatColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new FloatFirstBufferAggregator(metricFactory.makeLongColumnSelector("__time"), floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return TIME_COMPARATOR.compare(lhs, rhs) <= 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("FloatFirstAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatFirstAggregatorFactory(this.name, this.name){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(FloatFirstAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new FloatFirstAggregator(FloatFirstAggregatorFactory.this.name, null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.get();
                        if ((Long)pair.lhs < this.firstTime) {
                            this.firstTime = (Long)pair.lhs;
                            this.firstValue = ((Float)pair.rhs).floatValue();
                        }
                    }
                }, (ColumnValueSelector)selector);
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(FloatFirstAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new FloatFirstBufferAggregator(null, null){

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.get();
                        long firstTime = buf.getLong(position);
                        if ((Long)pair.lhs < firstTime) {
                            buf.putLong(position, (Long)pair.lhs);
                            buf.putFloat(position + 8, ((Float)pair.rhs).floatValue());
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                }, (ColumnValueSelector)selector);
            }
        };
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new FloatFirstAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePair<Long, Float>(((Number)map.get("lhs")).longValue(), Float.valueOf(((Number)map.get("rhs")).floatValue()));
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object == null ? object : ((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8(this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)22).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + NullHandlingHelper.extraAggregatorBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatFirstAggregatorFactory that = (FloatFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name);
    }

    public String toString() {
        return "FloatFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

