/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregator;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public abstract class SimpleDoubleAggregatorFactory
extends AggregatorFactory {
    protected final String name;
    protected final String fieldName;
    protected final String expression;
    protected final ExprMacroTable macroTable;

    public SimpleDoubleAggregatorFactory(ExprMacroTable macroTable, String fieldName, String name, String expression) {
        this.macroTable = macroTable;
        this.fieldName = fieldName;
        this.name = name;
        this.expression = expression;
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkArgument(fieldName == null ^ expression == null, "Must have a valid, non-null fieldName or expression");
    }

    protected DoubleColumnSelector getDoubleColumnSelector(ColumnSelectorFactory metricFactory, Double nullValue) {
        return AggregatorUtil.getDoubleColumnSelector(metricFactory, this.macroTable, this.fieldName, this.expression, nullValue);
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public String getTypeName() {
        return "double";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8 + NullHandlingHelper.extraAggregatorBytes();
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : Parser.findRequiredBindings(Parser.parse(this.expression, this.macroTable));
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }
}

