/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.Histogram;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;

public class HistogramBufferAggregator
implements BufferAggregator {
    private final FloatColumnSelector selector;
    private final float[] breaks;
    private final int minOffset;
    private final int maxOffset;

    public HistogramBufferAggregator(FloatColumnSelector selector, float[] breaks) {
        this.selector = selector;
        this.breaks = breaks;
        this.minOffset = 8 * (breaks.length + 1);
        this.maxOffset = this.minOffset + 4;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        long[] bins = new long[this.breaks.length + 1];
        mutationBuffer.asLongBuffer().put(bins);
        mutationBuffer.putFloat(position + this.minOffset, Float.POSITIVE_INFINITY);
        mutationBuffer.putFloat(position + this.maxOffset, Float.NEGATIVE_INFINITY);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        int index;
        float value = this.selector.getFloat();
        int minPos = position + this.minOffset;
        int maxPos = position + this.maxOffset;
        if (value < buf.getFloat(minPos)) {
            buf.putFloat(minPos, value);
        }
        if (value > buf.getFloat(maxPos)) {
            buf.putFloat(maxPos, value);
        }
        index = (index = Arrays.binarySearch(this.breaks, value)) >= 0 ? index : -(index + 1);
        int offset = position + index * 8;
        long count = buf.getLong(offset);
        buf.putLong(offset, count + 1L);
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        long[] bins = new long[this.breaks.length + 1];
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.asLongBuffer().get(bins);
        float min = mutationBuffer.getFloat(position + this.minOffset);
        float max = mutationBuffer.getFloat(position + this.maxOffset);
        return new Histogram(this.breaks, bins, min, max);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HistogramBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HistogramBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HistogramBufferAggregator does not support getDouble");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

