/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;

public class DoubleSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        @Override
        public int compare(Object o, Object o1) {
            return Doubles.compare(((Number)o).doubleValue(), ((Number)o1).doubleValue());
        }
    }.nullsFirst();
    private final DoubleColumnSelector selector;
    private double sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
    }

    public DoubleSumAggregator(DoubleColumnSelector selector) {
        this.selector = selector;
        this.sum = 0.0;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getDouble();
    }

    @Override
    public void reset() {
        this.sum = 0.0;
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return (float)this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    public Aggregator clone() {
        return new DoubleSumAggregator(this.selector);
    }

    @Override
    public void close() {
    }

    @Override
    public double getDouble() {
        return this.sum;
    }
}

