/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;

public class DoubleMaxAggregator
implements Aggregator {
    private final DoubleColumnSelector selector;
    private double max;

    static double combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    public DoubleMaxAggregator(DoubleColumnSelector selector) {
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getDouble());
    }

    @Override
    public void reset() {
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return (float)this.max;
    }

    @Override
    public long getLong() {
        return (long)this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    public Aggregator clone() {
        return new DoubleMaxAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

