/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.PostProcessingOperator;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;

public class TimewarpOperator<T>
implements PostProcessingOperator<T> {
    private final Interval dataInterval;
    private final long periodMillis;
    private final long originMillis;

    @JsonCreator
    public TimewarpOperator(@JsonProperty(value="dataInterval") Interval dataInterval, @JsonProperty(value="period") Period period, @JsonProperty(value="origin") DateTime origin) {
        this.originMillis = origin.getMillis();
        this.dataInterval = dataInterval;
        this.periodMillis = period.toStandardDuration().getMillis();
    }

    @Override
    public QueryRunner<T> postProcess(QueryRunner<T> baseQueryRunner) {
        return this.postProcess(baseQueryRunner, DateTime.now().getMillis());
    }

    public QueryRunner<T> postProcess(final QueryRunner<T> baseRunner, final long now) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(final QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
                final long offset = TimewarpOperator.this.computeOffset(now);
                Interval interval = queryPlus.getQuery().getIntervals().get(0);
                Interval modifiedInterval = new Interval(Math.min(interval.getStartMillis() + offset, now + offset), Math.min(interval.getEndMillis() + offset, now + offset));
                return Sequences.map(baseRunner.run(queryPlus.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Arrays.asList(modifiedInterval))), responseContext), new Function<T, T>(){

                    @Override
                    public T apply(T input) {
                        if (input instanceof Result) {
                            Result res = (Result)input;
                            Object value = res.getValue();
                            if (value instanceof TimeBoundaryResultValue) {
                                TimeBoundaryResultValue boundary = (TimeBoundaryResultValue)value;
                                DateTime minTime = null;
                                try {
                                    minTime = boundary.getMinTime();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                DateTime maxTime = boundary.getMaxTime();
                                return ((TimeBoundaryQuery)queryPlus.getQuery()).buildResult(new DateTime(Math.min(res.getTimestamp().getMillis() - offset, now)), minTime != null ? minTime.minus(offset) : null, maxTime != null ? new DateTime(Math.min(maxTime.getMillis() - offset, now)) : null).iterator().next();
                            }
                            return new Result(res.getTimestamp().minus(offset), value);
                        }
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            return new MapBasedRow(row.getTimestamp().minus(offset), row.getEvent());
                        }
                        return input;
                    }
                });
            }
        };
    }

    protected long computeOffset(long t) {
        long start = this.dataInterval.getEndMillis() - this.periodMillis;
        long startOffset = start % this.periodMillis - this.originMillis % this.periodMillis;
        if (startOffset < 0L) {
            startOffset += this.periodMillis;
        }
        start -= startOffset;
        long tOffset = t % this.periodMillis - this.originMillis % this.periodMillis;
        if (tOffset < 0L) {
            tOffset += this.periodMillis;
        }
        return (tOffset += start) - t;
    }
}

