/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.MergeIterable;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, QueryRunner<T> ... queryables) {
        this(exec, queryWatcher, Arrays.asList(queryables));
    }

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator(exec);
        this.queryables = Iterables.unmodifiableIterable(queryables);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        final int priority = QueryContexts.getPriority(query);
        final Ordering<T> ordering = query.getResultOrdering();
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                ListenableFuture futures = Futures.allAsList(Lists.newArrayList(Iterables.transform(ChainedExecutionQueryRunner.this.queryables, new Function<QueryRunner<T>, ListenableFuture<Iterable<T>>>(){

                    @Override
                    public ListenableFuture<Iterable<T>> apply(final QueryRunner<T> input) {
                        if (input == null) {
                            throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                        }
                        return ChainedExecutionQueryRunner.this.exec.submit(new AbstractPrioritizedCallable<Iterable<T>>(priority){

                            @Override
                            public Iterable<T> call() throws Exception {
                                try {
                                    Sequence result = input.run(threadSafeQueryPlus, (Map<String, Object>)responseContext);
                                    if (result == null) {
                                        throw new ISE("Got a null result! Segments are missing!", new Object[0]);
                                    }
                                    ArrayList retVal = Sequences.toList(result, Lists.newArrayList());
                                    if (retVal == null) {
                                        throw new ISE("Got a null list of results! WTF?!", new Object[0]);
                                    }
                                    return retVal;
                                }
                                catch (QueryInterruptedException e) {
                                    throw Throwables.propagate(e);
                                }
                                catch (Exception e) {
                                    log.error(e, "Exception with one of the sequences!", new Object[0]);
                                    throw Throwables.propagate(e);
                                }
                            }
                        });
                    }
                })));
                ChainedExecutionQueryRunner.this.queryWatcher.registerQuery(query, futures);
                try {
                    return new MergeIterable(ordering.nullsFirst(), QueryContexts.hasTimeout(query) ? (Iterable)futures.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS) : (Iterable)futures.get()).iterator();
                }
                catch (InterruptedException e) {
                    log.warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e);
                }
                catch (TimeoutException e) {
                    log.info("Query timeout, cancelling pending results for query id [%s]", query.getId());
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate(e.getCause());
                }
            }

            @Override
            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

