/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.hive.druid.io.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataSupervisorManager;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLMetadataSupervisorManager
implements MetadataSupervisorManager {
    private final ObjectMapper jsonMapper;
    private final SQLMetadataConnector connector;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final IDBI dbi;

    @Inject
    public SQLMetadataSupervisorManager(@Json ObjectMapper jsonMapper, SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.dbTables = dbTables;
        this.dbi = connector.getDBI();
    }

    @Override
    @LifecycleStart
    public void start() {
        this.connector.createSupervisorsTable();
    }

    @Override
    public void insert(final String id, final SupervisorSpec spec) {
        this.dbi.withHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                ((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s (spec_id, created_date, payload) VALUES (:spec_id, :created_date, :payload)", SQLMetadataSupervisorManager.this.getSupervisorsTable())).bind("spec_id", id)).bind("created_date", new DateTime().toString())).bind("payload", SQLMetadataSupervisorManager.this.jsonMapper.writeValueAsBytes(spec))).execute();
                return null;
            }
        });
    }

    @Override
    public Map<String, List<VersionedSupervisorSpec>> getAll() {
        return ImmutableMap.copyOf(this.dbi.withHandle(new HandleCallback<Map<String, List<VersionedSupervisorSpec>>>(){

            @Override
            public Map<String, List<VersionedSupervisorSpec>> withHandle(Handle handle) throws Exception {
                return handle.createQuery(StringUtils.format("SELECT id, spec_id, created_date, payload FROM %1$s ORDER BY id DESC", SQLMetadataSupervisorManager.this.getSupervisorsTable())).map(new ResultSetMapper<Pair<String, VersionedSupervisorSpec>>(){

                    @Override
                    public Pair<String, VersionedSupervisorSpec> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            SupervisorSpec payload = (SupervisorSpec)SQLMetadataSupervisorManager.this.jsonMapper.readValue(r.getBytes("payload"), (TypeReference)new TypeReference<SupervisorSpec>(){});
                            return Pair.of(r.getString("spec_id"), new VersionedSupervisorSpec(payload, r.getString("created_date")));
                        }
                        catch (IOException e) {
                            throw Throwables.propagate(e);
                        }
                    }
                }).fold(Maps.newHashMap(), new Folder3<Map<String, List<VersionedSupervisorSpec>>, Pair<String, VersionedSupervisorSpec>>(){

                    @Override
                    public Map<String, List<VersionedSupervisorSpec>> fold(Map<String, List<VersionedSupervisorSpec>> retVal, Pair<String, VersionedSupervisorSpec> pair, FoldController foldController, StatementContext statementContext) throws SQLException {
                        try {
                            String specId = (String)pair.lhs;
                            if (!retVal.containsKey(specId)) {
                                retVal.put(specId, Lists.newArrayList());
                            }
                            retVal.get(specId).add((VersionedSupervisorSpec)pair.rhs);
                            return retVal;
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                });
            }
        }));
    }

    @Override
    public Map<String, SupervisorSpec> getLatest() {
        return ImmutableMap.copyOf(this.dbi.withHandle(new HandleCallback<Map<String, SupervisorSpec>>(){

            @Override
            public Map<String, SupervisorSpec> withHandle(Handle handle) throws Exception {
                return handle.createQuery(StringUtils.format("SELECT r.spec_id, r.payload FROM %1$s r INNER JOIN(SELECT spec_id, max(id) as id FROM %1$s GROUP BY spec_id) latest ON r.id = latest.id", SQLMetadataSupervisorManager.this.getSupervisorsTable())).map(new ResultSetMapper<Pair<String, SupervisorSpec>>(){

                    @Override
                    public Pair<String, SupervisorSpec> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of(r.getString("spec_id"), SQLMetadataSupervisorManager.this.jsonMapper.readValue(r.getBytes("payload"), (TypeReference)new TypeReference<SupervisorSpec>(){}));
                        }
                        catch (IOException e) {
                            throw Throwables.propagate(e);
                        }
                    }
                }).fold(Maps.newHashMap(), new Folder3<Map<String, SupervisorSpec>, Pair<String, SupervisorSpec>>(){

                    @Override
                    public Map<String, SupervisorSpec> fold(Map<String, SupervisorSpec> retVal, Pair<String, SupervisorSpec> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                        try {
                            retVal.put((String)stringObjectMap.lhs, (SupervisorSpec)stringObjectMap.rhs);
                            return retVal;
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                });
            }
        }));
    }

    private String getSupervisorsTable() {
        return this.dbTables.get().getSupervisorTable();
    }
}

