/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import com.google.inject.Inject;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.audit.AuditManager;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManagerConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManagerProvider;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataRuleManager;
import org.apache.hive.druid.io.druid.server.audit.SQLAuditManager;
import org.skife.jdbi.v2.IDBI;

public class SQLMetadataRuleManagerProvider
implements MetadataRuleManagerProvider {
    private final ObjectMapper jsonMapper;
    private final MetadataRuleManagerConfig config;
    private final MetadataStorageTablesConfig dbTables;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;
    private final IDBI dbi;
    private final AuditManager auditManager;

    @Inject
    public SQLMetadataRuleManagerProvider(ObjectMapper jsonMapper, MetadataRuleManagerConfig config, MetadataStorageTablesConfig dbTables, SQLMetadataConnector connector, Lifecycle lifecycle, SQLAuditManager auditManager) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.connector = connector;
        this.dbi = connector.getDBI();
        this.lifecycle = lifecycle;
        this.auditManager = auditManager;
    }

    @Override
    public SQLMetadataRuleManager get() {
        try {
            this.lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() throws Exception {
                    SQLMetadataRuleManagerProvider.this.connector.createRulesTable();
                    SQLMetadataRuleManager.createDefaultRule(SQLMetadataRuleManagerProvider.this.dbi, SQLMetadataRuleManagerProvider.this.dbTables.getRulesTable(), SQLMetadataRuleManagerProvider.this.config.getDefaultRule(), SQLMetadataRuleManagerProvider.this.jsonMapper);
                }

                @Override
                public void stop() {
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        return new SQLMetadataRuleManager(this.jsonMapper, this.config, this.dbTables, this.connector, this.auditManager);
    }
}

