/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.granularity;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class DurationGranularity
extends Granularity {
    private final long duration;
    private final long origin;

    @JsonCreator
    public DurationGranularity(@JsonProperty(value="duration") long duration, @JsonProperty(value="origin") DateTime origin) {
        this(duration, origin == null ? 0L : origin.getMillis());
    }

    public DurationGranularity(long duration, long origin) {
        Preconditions.checkArgument(duration > 0L, "duration should be greater than 0!");
        this.duration = duration;
        this.origin = origin % duration;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="origin")
    public DateTime getOrigin() {
        return new DateTime(this.origin);
    }

    public long getOriginMillis() {
        return this.origin;
    }

    @Override
    public DateTimeFormatter getFormatter(Granularity.Formatter type) {
        throw new UnsupportedOperationException("This method should not be invoked for this granularity type");
    }

    @Override
    public DateTime increment(DateTime time) {
        return new DateTime(time.getMillis() + this.getDurationMillis());
    }

    @Override
    public DateTime decrement(DateTime time) {
        return new DateTime(time.getMillis() - this.getDurationMillis());
    }

    @Override
    public DateTime bucketStart(DateTime time) {
        long duration;
        long t = time.getMillis();
        long offset = t % (duration = this.getDurationMillis()) - this.origin;
        if (offset < 0L) {
            offset += duration;
        }
        return new DateTime(t - offset);
    }

    @Override
    public DateTime toDate(String filePath, Granularity.Formatter formatter) {
        throw new UnsupportedOperationException("This method should not be invoked for this granularity type");
    }

    @Override
    public byte[] getCacheKey() {
        return ByteBuffer.allocate(16).putLong(this.duration).putLong(this.origin).array();
    }

    public long getDurationMillis() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationGranularity that = (DurationGranularity)o;
        if (this.duration != that.duration) {
            return false;
        }
        return this.origin == that.origin;
    }

    public int hashCode() {
        int result = (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
        return result;
    }

    public String toString() {
        return "DurationGranularity{duration=" + this.duration + ", origin=" + this.origin + '}';
    }
}

