/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.indexing.overlord;

import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentPublishResult {
    private final Set<DataSegment> segments;
    private final boolean success;

    @JsonCreator
    public SegmentPublishResult(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="success") boolean success) {
        this.segments = Preconditions.checkNotNull(segments, "segments");
        this.success = success;
        if (!success) {
            Preconditions.checkArgument(segments.isEmpty(), "segments must be empty for unsuccessful publishes");
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPublishResult that = (SegmentPublishResult)o;
        return this.success == that.success && Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.success);
    }

    public String toString() {
        return "SegmentPublishResult{segments=" + this.segments + ", success=" + this.success + '}';
    }
}

