/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.hive.druid.io.druid.common.aws.AWSCredentialsConfig;
import org.apache.hive.druid.io.druid.common.aws.AWSCredentialsUtils;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;

public class AWSModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.s3", AWSCredentialsConfig.class);
    }

    @Provides
    @LazySingleton
    public AWSCredentialsProvider getAWSCredentialsProvider(AWSCredentialsConfig config) {
        return AWSCredentialsUtils.defaultAWSCredentialsProviderChain((AWSCredentialsConfig)config);
    }

    @Provides
    @LazySingleton
    public AmazonEC2 getEc2Client(AWSCredentialsProvider credentials) {
        return new AmazonEC2Client(credentials);
    }
}

