/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hive.druid.io.druid.curator.CuratorConfig;
import org.apache.hive.druid.io.druid.curator.ExhibitorConfig;
import org.apache.hive.druid.io.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    static final String CURATOR_CONFIG_PREFIX = "druid.zk.service";
    static final String EXHIBITOR_CONFIG_PREFIX = "druid.exhibitor.service";
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_TIME_MS = 45000;
    private static final int MAX_RETRIES = 30;
    private static final Logger log = new Logger(CuratorModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, CURATOR_CONFIG_PREFIX, CuratorConfig.class);
        JsonConfigProvider.bind(binder, EXHIBITOR_CONFIG_PREFIX, ExhibitorConfig.class);
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(CuratorConfig config, EnsembleProvider ensembleProvider, Lifecycle lifecycle) throws IOException {
        final CuratorFramework framework = CuratorFrameworkFactory.builder().ensembleProvider(ensembleProvider).sessionTimeoutMs(config.getZkSessionTimeoutMs().intValue()).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(1000, 45000, 30)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                log.info("Starting Curator", new Object[0]);
                framework.start();
            }

            @Override
            public void stop() {
                log.info("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
        return framework;
    }

    @Provides
    @LazySingleton
    public EnsembleProvider makeEnsembleProvider(CuratorConfig config, ExhibitorConfig exConfig) {
        if (exConfig.getHosts().isEmpty()) {
            return new FixedEnsembleProvider(config.getZkHosts());
        }
        return new ExhibitorEnsembleProvider(new Exhibitors(exConfig.getHosts(), exConfig.getRestPort(), this.newBackupProvider(config.getZkHosts())), (ExhibitorRestClient)new DefaultExhibitorRestClient(exConfig.getUseSsl()), exConfig.getRestUriPath(), exConfig.getPollingMs(), (RetryPolicy)new BoundedExponentialBackoffRetry(1000, 45000, 30)){

            public void start() throws Exception {
                log.info("Poll the list of zookeeper servers for initial ensemble", new Object[0]);
                this.pollForInitialEnsemble();
                super.start();
            }
        };
    }

    private Exhibitors.BackupConnectionStringProvider newBackupProvider(final String zkHosts) {
        return new Exhibitors.BackupConnectionStringProvider(){

            public String getBackupConnectionString() throws Exception {
                return zkHosts;
            }
        };
    }

    static class SecuredACLProvider
    implements ACLProvider {
        SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

