/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.hive.druid.io.druid.java.util.common.ISE;

public class SocketUtil {
    private static final Random rnd = new Random(System.currentTimeMillis());

    public static int findOpenPort(int basePort) {
        int startPort = basePort < 0 ? -1 : rnd.nextInt(Short.MAX_VALUE) + basePort;
        return SocketUtil.findOpenPortFrom(startPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findOpenPortFrom(int startPort) {
        int currPort = startPort;
        while (currPort < 65535) {
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(currPort);
                int n = currPort;
                return n;
            }
            catch (IOException e) {
                ++currPort;
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ISE("Unable to find open port between [%d] and [%d]", startPort, currPort);
    }
}

