/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.OutputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.collections.IntList;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;

public class SerializerUtils {
    public static void writeBigEndianLongToOutputStream(OutputStream out, long value, ByteBuffer helperBuffer) throws IOException {
        if (helperBuffer.order() != ByteOrder.BIG_ENDIAN || !helperBuffer.hasArray()) {
            throw new IllegalArgumentException("Expected writable, big-endian, heap byteBuffer");
        }
        helperBuffer.putLong(0, value);
        out.write(helperBuffer.array(), helperBuffer.arrayOffset(), 8);
    }

    public static void writeNativeOrderedLongToOutputStream(OutputStream out, long value, ByteBuffer helperBuffer) throws IOException {
        if (helperBuffer.order() != ByteOrder.nativeOrder() || !helperBuffer.hasArray()) {
            throw new IllegalArgumentException("Expected writable heap byteBuffer with the native byte order");
        }
        helperBuffer.putLong(0, value);
        out.write(helperBuffer.array(), helperBuffer.arrayOffset(), 8);
    }

    public static void writeBigEndianIntToOutputStream(OutputStream out, int value, ByteBuffer helperBuffer) throws IOException {
        if (helperBuffer.order() != ByteOrder.BIG_ENDIAN || !helperBuffer.hasArray()) {
            throw new IllegalArgumentException("Expected writable, big-endian, heap byteBuffer");
        }
        helperBuffer.putInt(0, value);
        out.write(helperBuffer.array(), helperBuffer.arrayOffset(), 4);
    }

    public static void writeNativeOrderedIntToOutputStream(OutputStream out, int value, ByteBuffer helperBuffer) throws IOException {
        if (helperBuffer.order() != ByteOrder.nativeOrder() || !helperBuffer.hasArray()) {
            throw new IllegalArgumentException("Expected writable heap byteBuffer with the native byte order");
        }
        helperBuffer.putInt(0, value);
        out.write(helperBuffer.array(), helperBuffer.arrayOffset(), 4);
    }

    public <T extends OutputStream> void writeString(T out, String name) throws IOException {
        byte[] nameBytes = StringUtils.toUtf8(name);
        this.writeInt(out, nameBytes.length);
        out.write(nameBytes);
    }

    public void writeString(OutputSupplier<? extends OutputStream> supplier, String name) throws IOException {
        try (OutputStream out = supplier.getOutput();){
            this.writeString(out, name);
        }
    }

    public void writeString(WritableByteChannel out, String name) throws IOException {
        byte[] nameBytes = StringUtils.toUtf8(name);
        this.writeInt(out, nameBytes.length);
        out.write(ByteBuffer.wrap(nameBytes));
    }

    public String readString(InputStream in) throws IOException {
        int length = this.readInt(in);
        byte[] stringBytes = new byte[length];
        ByteStreams.readFully(in, stringBytes);
        return StringUtils.fromUtf8(stringBytes);
    }

    public String readString(ByteBuffer in) throws IOException {
        int length = in.getInt();
        return StringUtils.fromUtf8(this.readBytes(in, length));
    }

    public byte[] readBytes(ByteBuffer in, int length) throws IOException {
        byte[] bytes = new byte[length];
        in.get(bytes);
        return bytes;
    }

    public void writeStrings(OutputStream out, String[] names) throws IOException {
        this.writeStrings(out, Arrays.asList(names));
    }

    public void writeStrings(OutputStream out, List<String> names) throws IOException {
        this.writeInt(out, names.size());
        for (String name : names) {
            this.writeString(out, name);
        }
    }

    public String[] readStrings(InputStream in) throws IOException {
        int length = this.readInt(in);
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    public String[] readStrings(ByteBuffer in) throws IOException {
        int length = in.getInt();
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    public void writeInt(OutputStream out, int intValue) throws IOException {
        out.write(Ints.toByteArray(intValue));
    }

    public void writeInt(WritableByteChannel out, int intValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(intValue);
        buffer.flip();
        out.write(buffer);
    }

    public int readInt(InputStream in) throws IOException {
        byte[] intBytes = new byte[4];
        ByteStreams.readFully(in, intBytes);
        return Ints.fromByteArray(intBytes);
    }

    public void writeInts(OutputStream out, int[] ints) throws IOException {
        this.writeInt(out, ints.length);
        for (int value : ints) {
            this.writeInt(out, value);
        }
    }

    public void writeInts(OutputStream out, IntList ints) throws IOException {
        this.writeInt(out, ints.length());
        for (int i = 0; i < ints.length(); ++i) {
            this.writeInt(out, ints.get(i));
        }
    }

    public int[] readInts(InputStream in) throws IOException {
        int size = this.readInt(in);
        int[] retVal = new int[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readInt(in);
        }
        return retVal;
    }

    public void writeLong(OutputStream out, long longValue) throws IOException {
        out.write(Longs.toByteArray(longValue));
    }

    public void writeLong(WritableByteChannel out, long longValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(longValue);
        buffer.flip();
        out.write(buffer);
    }

    public long readLong(InputStream in) throws IOException {
        byte[] longBytes = new byte[8];
        ByteStreams.readFully(in, longBytes);
        return Longs.fromByteArray(longBytes);
    }

    public void writeLongs(OutputStream out, long[] longs) throws IOException {
        this.writeInt(out, longs.length);
        for (long value : longs) {
            this.writeLong(out, value);
        }
    }

    public long[] readLongs(InputStream in) throws IOException {
        int size = this.readInt(in);
        long[] retVal = new long[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readLong(in);
        }
        return retVal;
    }

    public void writeFloat(OutputStream out, float floatValue) throws IOException {
        this.writeInt(out, Float.floatToRawIntBits(floatValue));
    }

    public void writeFloat(WritableByteChannel out, float floatValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(floatValue);
        buffer.flip();
        out.write(buffer);
    }

    public float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(this.readInt(in));
    }

    public void writeFloats(OutputStream out, float[] floats) throws IOException {
        this.writeInt(out, floats.length);
        for (float value : floats) {
            this.writeFloat(out, value);
        }
    }

    public float[] readFloats(InputStream in) throws IOException {
        int size = this.readInt(in);
        float[] retVal = new float[size];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.readFloat(in);
        }
        return retVal;
    }

    public int getSerializedStringByteSize(String str) {
        return 4 + StringUtils.toUtf8(str).length;
    }
}

