/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedConciseBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.io.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.io.druid.java.util.common.ISE;

public class ConciseBitmapFactory
implements BitmapFactory {
    private static final ImmutableConciseSet EMPTY_IMMUTABLE_BITMAP = new ImmutableConciseSet();
    private static final WrappedImmutableConciseBitmap WRAPPED_IMMUTABLE_CONCISE_BITMAP = new WrappedImmutableConciseBitmap(EMPTY_IMMUTABLE_BITMAP);

    private static Iterable<ImmutableConciseSet> unwrap(final Iterable<ImmutableBitmap> b) {
        return new Iterable<ImmutableConciseSet>(){

            @Override
            public Iterator<ImmutableConciseSet> iterator() {
                final Iterator i = b.iterator();
                return new Iterator<ImmutableConciseSet>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public ImmutableConciseSet next() {
                        WrappedImmutableConciseBitmap wrappedBitmap = (WrappedImmutableConciseBitmap)i.next();
                        if (wrappedBitmap == null) {
                            return EMPTY_IMMUTABLE_BITMAP;
                        }
                        return wrappedBitmap.getBitmap();
                    }
                };
            }
        };
    }

    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedConciseBitmap();
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return WRAPPED_IMMUTABLE_CONCISE_BITMAP;
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedConciseBitmap)) {
            throw new ISE("Cannot convert [%s]", mutableBitmap.getClass());
        }
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable(((WrappedConciseBitmap)mutableBitmap).getBitmap()));
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedImmutableConciseBitmap(b);
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) throws ClassCastException {
        if (b instanceof Collection) {
            Collection bitmapList = (Collection)b;
            int size = bitmapList.size();
            if (size == 0) {
                return this.makeEmptyImmutableBitmap();
            }
            if (size == 1) {
                return Iterables.getOnlyElement(b);
            }
        }
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.union(ConciseBitmapFactory.unwrap(b)));
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) throws ClassCastException {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection(ConciseBitmapFactory.unwrap(b)));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b) {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.complement(((WrappedImmutableConciseBitmap)b).getBitmap()));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.complement(((WrappedImmutableConciseBitmap)b).getBitmap(), length));
    }
}

