/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.indexing;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.io.druid.client.indexing.ClientAppendQuery;
import org.apache.hive.druid.io.druid.client.indexing.ClientConversionQuery;
import org.apache.hive.druid.io.druid.client.indexing.ClientKillQuery;
import org.apache.hive.druid.io.druid.client.indexing.IndexingService;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Interval;

public class IndexingServiceClient {
    private static final InputStreamResponseHandler RESPONSE_HANDLER = new InputStreamResponseHandler();
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final ServerDiscoverySelector selector;

    @Inject
    public IndexingServiceClient(@Global HttpClient client, ObjectMapper jsonMapper, @IndexingService ServerDiscoverySelector selector) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.selector = selector;
    }

    public void mergeSegments(List<DataSegment> segments) {
        Iterator<DataSegment> segmentsIter = segments.iterator();
        if (!segmentsIter.hasNext()) {
            return;
        }
        String dataSource = segmentsIter.next().getDataSource();
        while (segmentsIter.hasNext()) {
            DataSegment next = segmentsIter.next();
            if (dataSource.equals(next.getDataSource())) continue;
            throw new IAE("Cannot merge segments of different dataSources[%s] and [%s]", dataSource, next.getDataSource());
        }
        this.runQuery(new ClientAppendQuery(dataSource, segments));
    }

    public void killSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientKillQuery(dataSource, interval));
    }

    public void upgradeSegment(DataSegment dataSegment) {
        this.runQuery(new ClientConversionQuery(dataSegment));
    }

    public void upgradeSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientConversionQuery(dataSource, interval));
    }

    private InputStream runQuery(Object queryObject) {
        try {
            return (InputStream)this.client.go(new Request(HttpMethod.POST, new URL(StringUtils.format("%s/task", this.baseUrl()))).setContent("application/json", this.jsonMapper.writeValueAsBytes(queryObject)), RESPONSE_HANDLER).get();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private String baseUrl() {
        try {
            Server instance = this.selector.pick();
            if (instance == null) {
                throw new ISE("Cannot find instance of indexingService", new Object[0]);
            }
            return new URI(instance.getScheme(), null, instance.getAddress(), instance.getPort(), "/druid/indexer/v1", null, null).toString();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

