/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.coordinator;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.io.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.io.druid.client.coordinator.Coordinator;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorClient {
    private static final StatusResponseHandler RESPONSE_HANDLER = new StatusResponseHandler(Charsets.UTF_8);
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final ServerDiscoverySelector selector;

    @Inject
    public CoordinatorClient(@Global HttpClient client, ObjectMapper jsonMapper, @Coordinator ServerDiscoverySelector selector) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.selector = selector;
    }

    public List<ImmutableSegmentLoadInfo> fetchServerView(String dataSource, Interval interval, boolean incompleteOk) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.client.go(new Request(HttpMethod.GET, new URL(StringUtils.format("%s/datasources/%s/intervals/%s/serverview?partial=%s", this.baseUrl(), dataSource, interval.toString().replace("/", "_"), incompleteOk))), RESPONSE_HANDLER).get();
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<ImmutableSegmentLoadInfo>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private String baseUrl() {
        try {
            Server instance = this.selector.pick();
            if (instance == null) {
                throw new ISE("Cannot find instance of coordinator.. Did you set `druid.selectors.coordinator.serviceName`?", new Object[0]);
            }
            return new URI(instance.getScheme(), null, instance.getAddress(), instance.getPort(), "/druid/coordinator/v1", null, null).toString();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

