/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import com.google.inject.Inject;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheStats;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;

public class CacheMonitor
extends AbstractMonitor {
    volatile Cache cache;
    private volatile CacheStats prevCacheStats = null;

    public CacheMonitor() {
    }

    public CacheMonitor(Cache cache) {
        this.cache = cache;
    }

    @Inject(optional=true)
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.cache != null) {
            CacheStats currCacheStats = this.cache.getStats();
            CacheStats deltaCacheStats = currCacheStats.delta(this.prevCacheStats);
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            this.emitStats(emitter, "query/cache/delta", deltaCacheStats, builder);
            this.emitStats(emitter, "query/cache/total", currCacheStats, builder);
            this.prevCacheStats = currCacheStats;
            this.cache.doMonitor(emitter);
        }
        return true;
    }

    private void emitStats(ServiceEmitter emitter, String metricPrefix, CacheStats cacheStats, ServiceMetricEvent.Builder builder) {
        if (this.cache != null) {
            emitter.emit(builder.build(StringUtils.format("%s/numEntries", metricPrefix), cacheStats.getNumEntries()));
            emitter.emit(builder.build(StringUtils.format("%s/sizeBytes", metricPrefix), cacheStats.getSizeInBytes()));
            emitter.emit(builder.build(StringUtils.format("%s/hits", metricPrefix), cacheStats.getNumHits()));
            emitter.emit(builder.build(StringUtils.format("%s/misses", metricPrefix), cacheStats.getNumMisses()));
            emitter.emit(builder.build(StringUtils.format("%s/evictions", metricPrefix), cacheStats.getNumEvictions()));
            emitter.emit(builder.build(StringUtils.format("%s/hitRate", metricPrefix), cacheStats.hitRate()));
            emitter.emit(builder.build(StringUtils.format("%s/averageBytes", metricPrefix), cacheStats.averageBytes()));
            emitter.emit(builder.build(StringUtils.format("%s/timeouts", metricPrefix), cacheStats.getNumTimeouts()));
            emitter.emit(builder.build(StringUtils.format("%s/errors", metricPrefix), cacheStats.getNumErrors()));
        }
    }
}

