/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.cache.CacheStats;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;

public interface Cache {
    public byte[] get(NamedKey var1);

    public void put(NamedKey var1, byte[] var2);

    public Map<NamedKey, byte[]> getBulk(Iterable<NamedKey> var1);

    public void close(String var1);

    public CacheStats getStats();

    public boolean isLocal();

    public void doMonitor(ServiceEmitter var1);

    public static class NamedKey {
        public final String namespace;
        public final byte[] key;

        public NamedKey(String namespace, byte[] key) {
            Preconditions.checkArgument(namespace != null, "namespace must not be null");
            Preconditions.checkArgument(key != null, "key must not be null");
            this.namespace = namespace;
            this.key = key;
        }

        public byte[] toByteArray() {
            byte[] nsBytes = StringUtils.toUtf8(this.namespace);
            return ByteBuffer.allocate(4 + nsBytes.length + this.key.length).putInt(nsBytes.length).put(nsBytes).put(this.key).array();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedKey namedKey = (NamedKey)o;
            if (!this.namespace.equals(namedKey.namespace)) {
                return false;
            }
            return Arrays.equals(this.key, namedKey.key);
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + Arrays.hashCode(this.key);
            return result;
        }
    }
}

