/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class ImmutableDruidServer {
    private final DruidServerMetadata metadata;
    private final long currSize;
    private final ImmutableMap<String, ImmutableDruidDataSource> dataSources;
    private final ImmutableMap<String, DataSegment> segments;

    public ImmutableDruidServer(DruidServerMetadata metadata, long currSize, ImmutableMap<String, ImmutableDruidDataSource> dataSources, ImmutableMap<String, DataSegment> segments) {
        this.metadata = metadata;
        this.currSize = currSize;
        this.segments = segments;
        this.dataSources = dataSources;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public DruidServerMetadata getMetadata() {
        return this.metadata;
    }

    public String getHost() {
        return this.metadata.getHost();
    }

    public long getCurrSize() {
        return this.currSize;
    }

    public long getMaxSize() {
        return this.metadata.getMaxSize();
    }

    public ServerType getType() {
        return this.metadata.getType();
    }

    public String getTier() {
        return this.metadata.getTier();
    }

    public int getPriority() {
        return this.metadata.getPriority();
    }

    public DataSegment getSegment(String segmentName) {
        return this.segments.get(segmentName);
    }

    public Iterable<ImmutableDruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public ImmutableDruidDataSource getDataSource(String name) {
        return this.dataSources.get(name);
    }

    public Map<String, DataSegment> getSegments() {
        return this.segments;
    }

    public String toString() {
        return "ImmutableDruidServer{meta='" + this.metadata + "', size='" + this.currSize + "', sources='" + this.dataSources + "'}";
    }
}

